/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

class GradientTag
extends AbstractColorChangingTag {
    private static final String GRADIENT = "gradient";
    private static final TextColor DEFAULT_WHITE = TextColor.color(0xFFFFFF);
    private static final TextColor DEFAULT_BLACK = TextColor.color(0);
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("gradient", GradientTag::create, AbstractColorChangingTag::claimComponent);
    private int index = 0;
    private double multiplier = 1.0;
    private final TextColor[] colors;
    @Range(from=-1L, to=1L) double phase;
    private final boolean negativePhase;

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        List<TextColor> list;
        double d2 = 0.0;
        if (argumentQueue.hasNext()) {
            list = new ArrayList();
            while (argumentQueue.hasNext()) {
                OptionalDouble optionalDouble;
                Tag.Argument argument = argumentQueue.pop();
                String string = argument.value();
                TextColor textColor = ColorTagResolver.resolveColorOrNull(string);
                if (textColor != null) {
                    list.add(textColor);
                    continue;
                }
                if (!argumentQueue.hasNext() && (optionalDouble = argument.asDouble()).isPresent()) {
                    d2 = optionalDouble.getAsDouble();
                    if (!(d2 < -1.0) && !(d2 > 1.0)) break;
                    throw context.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0, 1.0] (inclusive).", d2), argumentQueue);
                }
                throw context.newException(String.format("Unable to parse a color from '%s'. Please use named colors or hex (#RRGGBB) colors.", string), argumentQueue);
            }
            if (list.size() == 1) {
                throw context.newException("Invalid gradient, not enough colors. Gradients must have at least two colors.", argumentQueue);
            }
        } else {
            list = Collections.emptyList();
        }
        return new GradientTag(d2, list, context);
    }

    GradientTag(double d2, List<TextColor> list, Context context) {
        super(context);
        this.colors = list.isEmpty() ? new TextColor[]{DEFAULT_WHITE, DEFAULT_BLACK} : list.toArray(new TextColor[0]);
        if (d2 < 0.0) {
            this.negativePhase = true;
            this.phase = 1.0 + d2;
            Collections.reverse(Arrays.asList(this.colors));
        } else {
            this.negativePhase = false;
            this.phase = d2;
        }
    }

    @Override
    protected void init() {
        this.multiplier = this.size() == 1 ? 0.0 : (double)(this.colors.length - 1) / (double)(this.size() - 1);
        this.phase *= (double)(this.colors.length - 1);
        this.index = 0;
    }

    @Override
    protected void advanceColor() {
        ++this.index;
    }

    @Override
    protected TextColor color() {
        double d2 = (double)this.index * this.multiplier + this.phase;
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.ceil(d2) % this.colors.length;
        int n4 = n2 % this.colors.length;
        return TextColor.lerp((float)d2 - (float)n2, this.colors[n4], this.colors[n3]);
    }

    @Override
    @NotNull
    protected Consumer<TokenEmitter> preserveData() {
        double d2;
        TextColor[] textColorArray;
        if (this.negativePhase) {
            textColorArray = Arrays.copyOf(this.colors, this.colors.length);
            Collections.reverse(Arrays.asList(textColorArray));
            d2 = this.phase - 1.0;
        } else {
            textColorArray = this.colors;
            d2 = this.phase;
        }
        return tokenEmitter -> {
            tokenEmitter.tag(GRADIENT);
            if (textColorArray.length != 2 || !textColorArray[0].equals(DEFAULT_WHITE) || !textColorArray[1].equals(DEFAULT_BLACK)) {
                for (TextColor textColor : textColorArray) {
                    if (textColor instanceof NamedTextColor) {
                        tokenEmitter.argument(NamedTextColor.NAMES.keyOrThrow((NamedTextColor)textColor));
                        continue;
                    }
                    tokenEmitter.argument(textColor.asHexString());
                }
            }
            if (d2 != 0.0) {
                tokenEmitter.argument(Double.toString(d2));
            }
        };
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GradientTag gradientTag = (GradientTag)object;
        return this.index == gradientTag.index && this.phase == gradientTag.phase && Arrays.equals(this.colors, gradientTag.colors);
    }

    @Override
    public int hashCode() {
        int n2 = Objects.hash(this.index, this.phase);
        n2 = 31 * n2 + Arrays.hashCode(this.colors);
        return n2;
    }
}

