/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import java.util.HashMap;
import java.util.Map;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ColorTagResolver
implements SerializableResolver.Single,
TagResolver {
    private static final String COLOR_3 = "c";
    private static final String COLOR_2 = "colour";
    private static final String COLOR = "color";
    static final TagResolver INSTANCE = new ColorTagResolver();
    private static final StyleClaim<TextColor> STYLE = StyleClaim.claim("color", Style::color, (textColor, tokenEmitter) -> {
        if (textColor instanceof NamedTextColor) {
            tokenEmitter.tag(NamedTextColor.NAMES.key((NamedTextColor)textColor));
        } else {
            tokenEmitter.tag(textColor.asHexString());
        }
    });
    private static final Map<String, TextColor> COLOR_ALIASES = new HashMap<String, TextColor>();

    private static boolean isColorOrAbbreviation(String string) {
        return string.equals(COLOR) || string.equals(COLOR_2) || string.equals(COLOR_3);
    }

    ColorTagResolver() {
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String string, @NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
        if (!this.has(string)) {
            return null;
        }
        String string2 = ColorTagResolver.isColorOrAbbreviation(string) ? argumentQueue.popOr("Expected to find a color parameter: <name>|#RRGGBB").lowerValue() : string;
        TextColor textColor = ColorTagResolver.resolveColor(string2, context);
        return Tag.styling(textColor);
    }

    @Nullable
    static TextColor resolveColorOrNull(String string) {
        TextColor textColor = COLOR_ALIASES.containsKey(string) ? COLOR_ALIASES.get(string) : (string.charAt(0) == '#' ? TextColor.fromHexString(string) : (TextColor)NamedTextColor.NAMES.value(string));
        return textColor;
    }

    @NotNull
    static TextColor resolveColor(@NotNull String string, @NotNull Context context) {
        TextColor textColor = ColorTagResolver.resolveColorOrNull(string);
        if (textColor == null) {
            throw context.newException(String.format("Unable to parse a color from '%s'. Please use named colours or hex (#RRGGBB) colors.", string));
        }
        return textColor;
    }

    @Override
    public boolean has(@NotNull String string) {
        return ColorTagResolver.isColorOrAbbreviation(string) || NamedTextColor.NAMES.value(string) != null || COLOR_ALIASES.containsKey(string) || TextColor.fromHexString(string) != null;
    }

    @Override
    @Nullable
    public StyleClaim<?> claimStyle() {
        return STYLE;
    }

    static {
        COLOR_ALIASES.put("dark_grey", NamedTextColor.DARK_GRAY);
        COLOR_ALIASES.put("grey", NamedTextColor.GRAY);
    }
}

