/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import java.util.Collections;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.internal.Internals;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.TextComponent;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponent;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponentRenderer;
import me.ulrich.clans.library.kyori.adventure.text.flattener.ComponentFlattener;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.parser.node.TagNode;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.parser.node.ValueNode;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Inserting;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Modifying;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tree.Node;
import me.ulrich.clans.library.kyori.examination.Examinable;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

abstract class AbstractColorChangingTag
implements Modifying,
Examinable {
    private static final ComponentFlattener LENGTH_CALCULATOR = (ComponentFlattener)ComponentFlattener.builder().mapper(TextComponent.class, TextComponent::content).unknownMapper(component -> "_").build();
    private boolean visited;
    private int size = 0;
    private int disableApplyingColorDepth = -1;
    private final boolean emitVirtuals;

    AbstractColorChangingTag(Context context) {
        this.emitVirtuals = context.emitVirtuals();
    }

    protected final int size() {
        return this.size;
    }

    @Override
    public final void visit(@NotNull Node node, int n2) {
        TagNode tagNode;
        if (this.visited) {
            throw new IllegalStateException("Color changing tag instances cannot be re-used, return a new one for each resolve");
        }
        if (node instanceof ValueNode) {
            String string2 = ((ValueNode)node).value();
            this.size += string2.codePointCount(0, string2.length());
        } else if (node instanceof TagNode && (tagNode = (TagNode)node).tag() instanceof Inserting) {
            LENGTH_CALCULATOR.flatten(((Inserting)tagNode.tag()).value(), string -> this.size += string.codePointCount(0, string.length()));
        }
    }

    @Override
    public final void postVisit() {
        this.visited = true;
        this.init();
    }

    @Override
    public final Component apply(@NotNull Component component, int n2) {
        if (this.emitVirtuals && n2 == 0) {
            return Component.virtual(Void.class, new TagInfoHolder(this.preserveData(), component), component.style());
        }
        if (this.disableApplyingColorDepth != -1 && n2 > this.disableApplyingColorDepth || component.style().color() != null) {
            if (this.disableApplyingColorDepth == -1 || n2 < this.disableApplyingColorDepth) {
                this.disableApplyingColorDepth = n2;
            }
            if (component instanceof TextComponent) {
                this.skipColorForLengthOf(((TextComponent)component).content());
            }
            return component.children(Collections.emptyList());
        }
        this.disableApplyingColorDepth = -1;
        if (component instanceof VirtualComponent) {
            this.skipColorForLengthOf(((VirtualComponent)component).content());
            return component.children(Collections.emptyList());
        }
        if (component instanceof TextComponent && ((TextComponent)component).content().length() > 0) {
            TextComponent textComponent = (TextComponent)component;
            String string = textComponent.content();
            TextComponent.Builder builder = Component.text();
            int[] nArray = new int[1];
            PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
            while (ofInt.hasNext()) {
                nArray[0] = ofInt.nextInt();
                TextComponent textComponent2 = Component.text(new String(nArray, 0, 1), component.style().color(this.color()));
                this.advanceColor();
                builder.append((Component)textComponent2);
            }
            return builder.build();
        }
        if (!(component instanceof TextComponent)) {
            Component component2 = component.children(Collections.emptyList()).colorIfAbsent(this.color());
            this.advanceColor();
            return component2;
        }
        return Component.empty().mergeStyle(component);
    }

    private void skipColorForLengthOf(String string) {
        int n2 = string.codePointCount(0, string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            this.advanceColor();
        }
    }

    protected abstract void init();

    protected abstract void advanceColor();

    protected abstract TextColor color();

    @NotNull
    protected abstract Consumer<TokenEmitter> preserveData();

    @Override
    @NotNull
    public abstract Stream<? extends ExaminableProperty> examinableProperties();

    @NotNull
    public final String toString() {
        return Internals.toString(this);
    }

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    @Nullable
    static Emitable claimComponent(Component component) {
        if (!(component instanceof VirtualComponent)) {
            return null;
        }
        VirtualComponentRenderer<?> virtualComponentRenderer = ((VirtualComponent)component).renderer();
        if (!(virtualComponentRenderer instanceof TagInfoHolder)) {
            return null;
        }
        return (TagInfoHolder)virtualComponentRenderer;
    }

    static final class TagInfoHolder
    implements VirtualComponentRenderer<Void>,
    Emitable {
        private final Consumer<TokenEmitter> output;
        private final Component originalComp;

        TagInfoHolder(Consumer<TokenEmitter> consumer, Component component) {
            this.output = consumer;
            this.originalComp = component;
        }

        @Override
        public @UnknownNullability ComponentLike apply(@NotNull Void void_) {
            return this.originalComp;
        }

        @Override
        @NotNull
        public String fallbackString() {
            return "";
        }

        @Override
        public void emit(@NotNull TokenEmitter tokenEmitter) {
            this.output.accept(tokenEmitter);
        }

        @Override
        @Nullable
        public Component substitute() {
            return this.originalComp;
        }
    }
}

