/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.TagInternals;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.TagPattern;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.CachingTagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.EmptyTagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.SingleResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolverBuilderImpl;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TagResolver {
    @NotNull
    public static Builder builder() {
        return new TagResolverBuilderImpl();
    }

    @NotNull
    public static TagResolver standard() {
        return StandardTags.defaults();
    }

    @NotNull
    public static TagResolver empty() {
        return EmptyTagResolver.INSTANCE;
    }

    public static @NotNull Single resolver(@TagPattern @NotNull String string, @NotNull Tag tag) {
        TagInternals.assertValidTagName(string);
        return new SingleResolver(string, Objects.requireNonNull(tag, "tag"));
    }

    @NotNull
    public static TagResolver resolver(@TagPattern @NotNull String string, @NotNull BiFunction<ArgumentQueue, Context, Tag> biFunction) {
        return TagResolver.resolver(Collections.singleton(string), biFunction);
    }

    @NotNull
    public static TagResolver resolver(final @NotNull Set<String> set, final @NotNull BiFunction<ArgumentQueue, Context, Tag> biFunction) {
        HashSet<String> hashSet = new HashSet<String>(set);
        for (String string : hashSet) {
            TagInternals.assertValidTagName(string);
        }
        Objects.requireNonNull(biFunction, "handler");
        return new TagResolver(){

            @Override
            @Nullable
            public Tag resolve(@NotNull String string, @NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
                if (!set.contains(string)) {
                    return null;
                }
                return (Tag)biFunction.apply(argumentQueue, context);
            }

            @Override
            public boolean has(@NotNull String string) {
                return set.contains(string);
            }
        };
    }

    @NotNull
    public static TagResolver resolver(TagResolver ... tagResolverArray) {
        if (Objects.requireNonNull(tagResolverArray, "resolvers").length == 1) {
            return Objects.requireNonNull(tagResolverArray[0], "resolvers must not contain null elements");
        }
        return TagResolver.builder().resolvers(tagResolverArray).build();
    }

    @NotNull
    public static TagResolver resolver(@NotNull Iterable<? extends TagResolver> iterable) {
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return TagResolver.empty();
            }
            if (n2 == 1) {
                return Objects.requireNonNull(iterable.iterator().next(), "resolvers must not contain null elements");
            }
        }
        return TagResolver.builder().resolvers(iterable).build();
    }

    @NotNull
    public static TagResolver caching(@NotNull WithoutArguments withoutArguments) {
        if (withoutArguments instanceof CachingTagResolver) {
            return withoutArguments;
        }
        return new CachingTagResolver(Objects.requireNonNull(withoutArguments, "resolver"));
    }

    @NotNull
    public static Collector<TagResolver, ?, TagResolver> toTagResolver() {
        return TagResolverBuilderImpl.COLLECTOR;
    }

    @Nullable
    public Tag resolve(@TagPattern @NotNull String var1, @NotNull ArgumentQueue var2, @NotNull Context var3);

    public boolean has(@NotNull String var1);

    public static interface Builder {
        @NotNull
        public Builder tag(@TagPattern @NotNull String var1, @NotNull Tag var2);

        @NotNull
        default public Builder tag(@TagPattern @NotNull String string, @NotNull BiFunction<ArgumentQueue, Context, Tag> biFunction) {
            return this.tag(Collections.singleton(string), biFunction);
        }

        @NotNull
        default public Builder tag(@NotNull Set<String> set, @NotNull BiFunction<ArgumentQueue, Context, Tag> biFunction) {
            return this.resolver(TagResolver.resolver(set, biFunction));
        }

        @NotNull
        public Builder resolver(@NotNull TagResolver var1);

        @NotNull
        public Builder resolvers(TagResolver ... var1);

        @NotNull
        public Builder resolvers(@NotNull Iterable<? extends TagResolver> var1);

        @NotNull
        default public Builder caching(@NotNull WithoutArguments withoutArguments) {
            return this.resolver(TagResolver.caching(withoutArguments));
        }

        @NotNull
        public TagResolver build();
    }

    @FunctionalInterface
    public static interface WithoutArguments
    extends TagResolver {
        @Nullable
        public Tag resolve(@TagPattern @NotNull String var1);

        @Override
        default public boolean has(@NotNull String string) {
            return this.resolve(string) != null;
        }

        @Override
        @Nullable
        default public Tag resolve(@TagPattern @NotNull String string, @NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
            Tag tag = this.resolve(string);
            if (tag != null && argumentQueue.hasNext()) {
                throw context.newException("Tag '<" + string + ">' does not accept any arguments");
            }
            return tag;
        }
    }

    @ApiStatus.NonExtendable
    public static interface Single
    extends WithoutArguments {
        @NotNull
        public String key();

        @NotNull
        public Tag tag();

        @Override
        @Nullable
        default public Tag resolve(@TagPattern @NotNull String string) {
            if (this.has(string)) {
                return this.tag();
            }
            return null;
        }

        @Override
        default public boolean has(@NotNull String string) {
            return string.equalsIgnoreCase(this.key());
        }
    }
}

