/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver;

import java.util.Arrays;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.ParsingException;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SequentialTagResolver
implements SerializableResolver,
TagResolver {
    final TagResolver[] resolvers;

    SequentialTagResolver(@NotNull @NotNull TagResolver @NotNull [] tagResolverArray) {
        this.resolvers = tagResolverArray;
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String string, @NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
        ParsingException parsingException = null;
        for (TagResolver tagResolver : this.resolvers) {
            try {
                Tag tag;
                if (!tagResolver.has(string) || (tag = tagResolver.resolve(string, argumentQueue, context)) == null) continue;
                return tag;
            }
            catch (ParsingException parsingException2) {
                argumentQueue.reset();
                if (parsingException == null) {
                    parsingException = parsingException2;
                    continue;
                }
                parsingException.addSuppressed(parsingException2);
            }
            catch (Exception exception) {
                argumentQueue.reset();
                ParsingException parsingException3 = context.newException("Exception thrown while parsing <" + string + ">", exception, argumentQueue);
                if (parsingException == null) {
                    parsingException = parsingException3;
                    continue;
                }
                parsingException.addSuppressed(parsingException3);
            }
        }
        if (parsingException != null) {
            throw parsingException;
        }
        return null;
    }

    @Override
    public boolean has(@NotNull String string) {
        for (TagResolver tagResolver : this.resolvers) {
            if (!tagResolver.has(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(@NotNull Component component, @NotNull ClaimConsumer claimConsumer) {
        for (TagResolver tagResolver : this.resolvers) {
            if (!(tagResolver instanceof SerializableResolver)) continue;
            ((SerializableResolver)((Object)tagResolver)).handle(component, claimConsumer);
        }
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SequentialTagResolver)) {
            return false;
        }
        SequentialTagResolver sequentialTagResolver = (SequentialTagResolver)object;
        return Arrays.equals(this.resolvers, sequentialTagResolver.resolvers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.resolvers);
    }
}

