/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.JoinConfiguration;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.TagPattern;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public final class Formatter {
    private Formatter() {
    }

    @NotNull
    public static TagResolver number(@TagPattern @NotNull String string, @NotNull Number number) {
        return TagResolver.resolver(string, (argumentQueue, context) -> {
            NumberFormat numberFormat;
            if (argumentQueue.hasNext()) {
                String string = argumentQueue.pop().value();
                if (argumentQueue.hasNext()) {
                    String string2 = argumentQueue.pop().value();
                    numberFormat = new DecimalFormat(string2, new DecimalFormatSymbols(Locale.forLanguageTag(string)));
                } else {
                    numberFormat = string.contains(".") ? new DecimalFormat(string, DecimalFormatSymbols.getInstance()) : DecimalFormat.getInstance(Locale.forLanguageTag(string));
                }
            } else {
                numberFormat = DecimalFormat.getInstance();
            }
            return Tag.inserting(context.deserialize(numberFormat.format(number)));
        });
    }

    @NotNull
    public static TagResolver date(@TagPattern @NotNull String string, @NotNull TemporalAccessor temporalAccessor) {
        return TagResolver.resolver(string, (argumentQueue, context) -> {
            String string = argumentQueue.popOr("Format expected.").value();
            return Tag.inserting(context.deserialize(DateTimeFormatter.ofPattern(string).format(temporalAccessor)));
        });
    }

    @NotNull
    public static TagResolver choice(@TagPattern @NotNull String string, Number number) {
        return TagResolver.resolver(string, (argumentQueue, context) -> {
            String string = argumentQueue.popOr("Format expected.").value();
            ChoiceFormat choiceFormat = new ChoiceFormat(string);
            return Tag.inserting(context.deserialize(choiceFormat.format(number)));
        });
    }

    public static TagResolver booleanChoice(@TagPattern @NotNull String string, boolean bl) {
        return TagResolver.resolver(string, (argumentQueue, context) -> {
            String string = argumentQueue.popOr("True format expected.").value();
            String string2 = argumentQueue.popOr("False format expected.").value();
            return Tag.inserting(context.deserialize(bl ? string : string2));
        });
    }

    public static TagResolver joining(@TagPattern @NotNull String string, @NotNull Iterable<? extends ComponentLike> iterable) {
        return TagResolver.resolver(string, (argumentQueue, context) -> {
            Object object;
            if (!argumentQueue.hasNext()) {
                return Tag.inserting(Component.join(JoinConfiguration.noSeparators(), iterable));
            }
            String string = argumentQueue.pop().value();
            JoinConfiguration.Builder builder = JoinConfiguration.builder().separator(context.deserialize(string));
            if (argumentQueue.hasNext()) {
                object = argumentQueue.pop().value();
                builder.lastSeparator(context.deserialize((String)object));
            }
            if (argumentQueue.hasNext()) {
                object = argumentQueue.pop().value();
                builder.lastSeparatorIfSerial(context.deserialize((String)object));
            }
            object = (JoinConfiguration)builder.build();
            return Tag.inserting(Component.join((JoinConfiguration)object, iterable));
        });
    }

    public static TagResolver joining(@TagPattern @NotNull String string, ComponentLike ... componentLikeArray) {
        return Formatter.joining(string, Arrays.asList(componentLikeArray));
    }
}

