/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.format.StyleBuilderApplicable;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.CallbackStylingTagImpl;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.InsertingImpl;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.PreProcess;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.PreProcessTagImpl;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.StylingTagImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Tag {
    @NotNull
    public static PreProcess preProcessParsed(@NotNull String string) {
        return new PreProcessTagImpl(Objects.requireNonNull(string, "content"));
    }

    @NotNull
    public static Tag inserting(@NotNull Component component) {
        return new InsertingImpl(true, Objects.requireNonNull(component, "content must not be null"));
    }

    @NotNull
    public static Tag inserting(@NotNull ComponentLike componentLike) {
        return Tag.inserting(Objects.requireNonNull(componentLike, "value").asComponent());
    }

    @NotNull
    public static Tag selfClosingInserting(@NotNull Component component) {
        return new InsertingImpl(false, Objects.requireNonNull(component, "content must not be null"));
    }

    @NotNull
    public static Tag selfClosingInserting(@NotNull ComponentLike componentLike) {
        return Tag.selfClosingInserting(Objects.requireNonNull(componentLike, "value").asComponent());
    }

    @NotNull
    public static Tag styling(Consumer<Style.Builder> consumer) {
        return new CallbackStylingTagImpl(consumer);
    }

    @NotNull
    public static Tag styling(StyleBuilderApplicable ... styleBuilderApplicableArray) {
        Objects.requireNonNull(styleBuilderApplicableArray, "actions");
        int n2 = styleBuilderApplicableArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (styleBuilderApplicableArray[i2] != null) continue;
            throw new NullPointerException("actions[" + i2 + "]");
        }
        return new StylingTagImpl(Arrays.copyOf(styleBuilderApplicableArray, styleBuilderApplicableArray.length));
    }

    @ApiStatus.NonExtendable
    public static interface Argument {
        @NotNull
        public String value();

        @NotNull
        default public String lowerValue() {
            return this.value().toLowerCase(Locale.ROOT);
        }

        default public boolean isTrue() {
            return "true".equals(this.value()) || "on".equals(this.value());
        }

        default public boolean isFalse() {
            return "false".equals(this.value()) || "off".equals(this.value());
        }

        @NotNull
        default public OptionalInt asInt() {
            try {
                return OptionalInt.of(Integer.parseInt(this.value()));
            }
            catch (NumberFormatException numberFormatException) {
                return OptionalInt.empty();
            }
        }

        @NotNull
        default public OptionalDouble asDouble() {
            try {
                return OptionalDouble.of(Double.parseDouble(this.value()));
            }
            catch (NumberFormatException numberFormatException) {
                return OptionalDouble.empty();
            }
        }
    }
}

