/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.format;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.format.StyleBuilderApplicable;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColorImpl;
import me.ulrich.clans.library.kyori.adventure.text.format.TextFormat;
import me.ulrich.clans.library.kyori.adventure.util.HSVLike;
import me.ulrich.clans.library.kyori.adventure.util.RGBLike;
import me.ulrich.clans.library.kyori.examination.Examinable;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface TextColor
extends Comparable<TextColor>,
StyleBuilderApplicable,
TextFormat,
RGBLike,
Examinable {
    public static final char HEX_CHARACTER = '#';
    public static final String HEX_PREFIX = "#";

    @NotNull
    public static TextColor color(int n2) {
        int n3 = n2 & 0xFFFFFF;
        NamedTextColor namedTextColor = NamedTextColor.namedColor(n3);
        return namedTextColor != null ? namedTextColor : new TextColorImpl(n3);
    }

    @NotNull
    public static TextColor color(@NotNull RGBLike rGBLike) {
        if (rGBLike instanceof TextColor) {
            return (TextColor)rGBLike;
        }
        return TextColor.color(rGBLike.red(), rGBLike.green(), rGBLike.blue());
    }

    @NotNull
    public static TextColor color(@NotNull HSVLike hSVLike) {
        float f2 = hSVLike.s();
        float f3 = hSVLike.v();
        if (f2 == 0.0f) {
            return TextColor.color(f3, f3, f3);
        }
        float f4 = hSVLike.h() * 6.0f;
        int n2 = (int)Math.floor(f4);
        float f5 = f4 - (float)n2;
        float f6 = f3 * (1.0f - f2);
        float f7 = f3 * (1.0f - f2 * f5);
        float f8 = f3 * (1.0f - f2 * (1.0f - f5));
        if (n2 == 0) {
            return TextColor.color(f3, f8, f6);
        }
        if (n2 == 1) {
            return TextColor.color(f7, f3, f6);
        }
        if (n2 == 2) {
            return TextColor.color(f6, f3, f8);
        }
        if (n2 == 3) {
            return TextColor.color(f6, f7, f3);
        }
        if (n2 == 4) {
            return TextColor.color(f8, f6, f3);
        }
        return TextColor.color(f3, f6, f7);
    }

    @NotNull
    public static TextColor color(@Range(from=0L, to=255L) int n2, @Range(from=0L, to=255L) int n3, @Range(from=0L, to=255L) int n4) {
        return TextColor.color((n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF);
    }

    @NotNull
    public static TextColor color(float f2, float f3, float f4) {
        return TextColor.color((int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f));
    }

    @Nullable
    public static TextColor fromHexString(@NotNull String string) {
        if (string.startsWith(HEX_PREFIX)) {
            try {
                int n2 = Integer.parseInt(string.substring(1), 16);
                return TextColor.color(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static TextColor fromCSSHexString(@NotNull String string) {
        if (string.startsWith(HEX_PREFIX)) {
            int n2;
            String string2 = string.substring(1);
            if (string2.length() != 3 && string2.length() != 6) {
                return null;
            }
            try {
                n2 = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (string2.length() == 6) {
                return TextColor.color(n2);
            }
            int n3 = (n2 & 0xF00) >> 8 | (n2 & 0xF00) >> 4;
            int n4 = (n2 & 0xF0) >> 4 | n2 & 0xF0;
            int n5 = (n2 & 0xF) << 4 | n2 & 0xF;
            return TextColor.color(n3, n4, n5);
        }
        return null;
    }

    public int value();

    @NotNull
    default public String asHexString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HEX_PREFIX);
        String string = Integer.toHexString(this.value());
        for (int i2 = 0; i2 < 6 - string.length(); ++i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString().toUpperCase(Locale.ROOT);
    }

    @Override
    default public @Range(from=0L, to=255L) int red() {
        return this.value() >> 16 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int green() {
        return this.value() >> 8 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int blue() {
        return this.value() & 0xFF;
    }

    @NotNull
    public static TextColor lerp(float f2, @NotNull RGBLike rGBLike, @NotNull RGBLike rGBLike2) {
        float f3 = Math.min(1.0f, Math.max(0.0f, f2));
        int n2 = rGBLike.red();
        int n3 = rGBLike2.red();
        int n4 = rGBLike.green();
        int n5 = rGBLike2.green();
        int n6 = rGBLike.blue();
        int n7 = rGBLike2.blue();
        return TextColor.color(Math.round((float)n2 + f3 * (float)(n3 - n2)), Math.round((float)n4 + f3 * (float)(n5 - n4)), Math.round((float)n6 + f3 * (float)(n7 - n6)));
    }

    @NotNull
    public static <C extends TextColor> C nearestColorTo(@NotNull List<C> list, @NotNull TextColor textColor) {
        Objects.requireNonNull(textColor, "color");
        float f2 = Float.MAX_VALUE;
        TextColor textColor2 = (TextColor)list.get(0);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TextColor textColor3 = (TextColor)list.get(i2);
            float f3 = TextColorImpl.distance(textColor.asHSV(), textColor3.asHSV());
            if (f3 < f2) {
                textColor2 = textColor3;
                f2 = f3;
            }
            if (f3 == 0.0f) break;
        }
        return (C)textColor2;
    }

    @Override
    default public void styleApply(@NotNull Style.Builder builder) {
        builder.color(this);
    }

    @Override
    default public int compareTo(TextColor textColor) {
        return Integer.compare(this.value(), textColor.value());
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.asHexString()));
    }
}

