/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.format;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.text.event.ClickEvent;
import me.ulrich.clans.library.kyori.adventure.text.event.HoverEventSource;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.format.TextDecoration;
import me.ulrich.clans.library.kyori.adventure.util.ARGBLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface StyleSetter<T extends StyleSetter<?>> {
    @NotNull
    public T font(@Nullable Key var1);

    @NotNull
    public T color(@Nullable TextColor var1);

    @NotNull
    public T colorIfAbsent(@Nullable TextColor var1);

    @NotNull
    public T shadowColor(@Nullable ARGBLike var1);

    @NotNull
    public T shadowColorIfAbsent(@Nullable ARGBLike var1);

    @NotNull
    default public T decorate(@NotNull TextDecoration textDecoration) {
        return this.decoration(textDecoration, TextDecoration.State.TRUE);
    }

    @NotNull
    default public T decorate(TextDecoration ... textDecorationArray) {
        EnumMap<TextDecoration, TextDecoration.State> enumMap = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        int n2 = textDecorationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            enumMap.put(textDecorationArray[i2], TextDecoration.State.TRUE);
        }
        return this.decorations(enumMap);
    }

    @NotNull
    default public T decoration(@NotNull TextDecoration textDecoration, boolean bl) {
        return this.decoration(textDecoration, TextDecoration.State.byBoolean(bl));
    }

    @NotNull
    public T decoration(@NotNull TextDecoration var1, @NotNull TextDecoration.State var2);

    @NotNull
    public T decorationIfAbsent(@NotNull TextDecoration var1, @NotNull TextDecoration.State var2);

    @NotNull
    public T decorations(@NotNull Map<TextDecoration, TextDecoration.State> var1);

    @NotNull
    default public T decorations(@NotNull Set<TextDecoration> set, boolean bl) {
        return this.decorations(set.stream().collect(Collectors.toMap(Function.identity(), textDecoration -> TextDecoration.State.byBoolean(bl))));
    }

    @NotNull
    public T clickEvent(@Nullable ClickEvent var1);

    @NotNull
    public T hoverEvent(@Nullable HoverEventSource<?> var1);

    @NotNull
    public T insertion(@Nullable String var1);
}

