/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.flattener;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.ulrich.clans.library.kyori.adventure.internal.properties.AdventureProperties;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.KeybindComponent;
import me.ulrich.clans.library.kyori.adventure.text.ObjectComponent;
import me.ulrich.clans.library.kyori.adventure.text.ScoreComponent;
import me.ulrich.clans.library.kyori.adventure.text.SelectorComponent;
import me.ulrich.clans.library.kyori.adventure.text.TextComponent;
import me.ulrich.clans.library.kyori.adventure.text.TranslatableComponent;
import me.ulrich.clans.library.kyori.adventure.text.flattener.ComponentFlattener;
import me.ulrich.clans.library.kyori.adventure.text.flattener.FlattenerListener;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.object.ObjectContents;
import me.ulrich.clans.library.kyori.adventure.text.object.PlayerHeadObjectContents;
import me.ulrich.clans.library.kyori.adventure.text.object.SpriteObjectContents;
import me.ulrich.clans.library.kyori.adventure.util.InheritanceAwareMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class ComponentFlattenerImpl
implements ComponentFlattener {
    static final ComponentFlattener BASIC = (ComponentFlattener)new BuilderImpl().mapper(KeybindComponent.class, keybindComponent -> keybindComponent.keybind()).mapper(ScoreComponent.class, scoreComponent -> {
        @Nullable String string = scoreComponent.value();
        return string != null ? string : "";
    }).mapper(SelectorComponent.class, SelectorComponent::pattern).mapper(TextComponent.class, TextComponent::content).mapper(TranslatableComponent.class, translatableComponent -> {
        @Nullable String string = translatableComponent.fallback();
        return string != null ? string : translatableComponent.key();
    }).mapper(ObjectComponent.class, objectComponent -> {
        ObjectContents objectContents = objectComponent.contents();
        if (objectContents instanceof SpriteObjectContents) {
            SpriteObjectContents spriteObjectContents = (SpriteObjectContents)objectContents;
            Key key = spriteObjectContents.atlas();
            return "[" + spriteObjectContents.sprite().asMinimalString() + (!key.equals(SpriteObjectContents.DEFAULT_ATLAS) ? "@" + key.asMinimalString() : "") + "]";
        }
        if (objectContents instanceof PlayerHeadObjectContents) {
            PlayerHeadObjectContents playerHeadObjectContents = (PlayerHeadObjectContents)objectContents;
            return "[" + (playerHeadObjectContents.name() != null ? playerHeadObjectContents.name() : "unknown player") + " head]";
        }
        return "";
    }).build();
    static final ComponentFlattener TEXT_ONLY = (ComponentFlattener)new BuilderImpl().mapper(TextComponent.class, TextComponent::content).build();
    private static final int MAX_DEPTH = 512;
    private final InheritanceAwareMap<Component, Handler> flatteners;
    private final Function<Component, String> unknownHandler;
    private final int maxNestedDepth;

    ComponentFlattenerImpl(InheritanceAwareMap<Component, Handler> inheritanceAwareMap, @Nullable Function<Component, String> function, int n2) {
        this.flatteners = inheritanceAwareMap;
        this.unknownHandler = function;
        this.maxNestedDepth = n2;
    }

    @Override
    public void flatten(@NotNull Component component, @NotNull FlattenerListener flattenerListener) {
        this.flatten0(component, flattenerListener, 0, 0);
    }

    private void flatten0(@NotNull Component component, @NotNull FlattenerListener flattenerListener, int n2, int n3) {
        Object object;
        Objects.requireNonNull(component, "input");
        Objects.requireNonNull(flattenerListener, "listener");
        if (component == Component.empty()) {
            return;
        }
        if (this.maxNestedDepth != -1 && n3 > this.maxNestedDepth) {
            throw new IllegalStateException("Exceeded maximum nesting depth of " + this.maxNestedDepth + " while attempting to flatten components!");
        }
        ArrayDeque<StackEntry> arrayDeque = new ArrayDeque<StackEntry>();
        ArrayDeque<Style> arrayDeque2 = new ArrayDeque<Style>();
        arrayDeque.push(new StackEntry(component, n2, 1));
        while (!arrayDeque.isEmpty()) {
            object = (StackEntry)arrayDeque.pop();
            int n4 = ((StackEntry)object).depth;
            if (n4 > 512) {
                throw new IllegalStateException("Exceeded maximum depth of 512 while attempting to flatten components!");
            }
            Component component2 = ((StackEntry)object).component;
            @Nullable Handler handler = this.flattener(component2);
            Style style = component2.style();
            flattenerListener.pushStyle(style);
            arrayDeque2.push(style);
            if (handler != null) {
                handler.handle(this, component2, flattenerListener, n4, n3);
            }
            if (!component2.children().isEmpty() && flattenerListener.shouldContinue()) {
                List<Component> list = component2.children();
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    if (i2 == list.size() - 1) {
                        arrayDeque.push(new StackEntry(list.get(i2), n4 + 1, ((StackEntry)object).stylesToPop + 1));
                        continue;
                    }
                    arrayDeque.push(new StackEntry(list.get(i2), n4 + 1, 1));
                }
                continue;
            }
            for (int i3 = ((StackEntry)object).stylesToPop; i3 > 0; --i3) {
                Style style2 = (Style)arrayDeque2.pop();
                flattenerListener.popStyle(style2);
            }
        }
        while (!arrayDeque2.isEmpty()) {
            object = (Style)arrayDeque2.pop();
            flattenerListener.popStyle((Style)object);
        }
    }

    @Nullable
    private <T extends Component> Handler flattener(T t2) {
        Handler handler = this.flatteners.get(t2.getClass());
        if (handler == null && this.unknownHandler != null) {
            return (componentFlattenerImpl, component, flattenerListener, n2, n3) -> flattenerListener.component(this.unknownHandler.apply(component));
        }
        return handler;
    }

    @Override
    public @NotNull ComponentFlattener.Builder toBuilder() {
        return new BuilderImpl(this.flatteners, this.unknownHandler, this.maxNestedDepth);
    }

    private static final class StackEntry {
        final Component component;
        final int depth;
        final int stylesToPop;

        StackEntry(Component component, int n2, int n3) {
            this.component = component;
            this.depth = n2;
            this.stylesToPop = n3;
        }
    }

    @FunctionalInterface
    static interface Handler {
        public void handle(ComponentFlattenerImpl var1, Component var2, FlattenerListener var3, int var4, int var5);
    }

    static final class BuilderImpl
    implements ComponentFlattener.Builder {
        private final InheritanceAwareMap.Builder<Component, Handler> flatteners;
        @Nullable
        private Function<Component, String> unknownHandler;
        private int maxNestedDepth = AdventureProperties.DEFAULT_FLATTENER_NESTING_LIMIT.valueOr(-1);

        BuilderImpl() {
            this.flatteners = InheritanceAwareMap.builder().strict(true);
        }

        BuilderImpl(InheritanceAwareMap<Component, Handler> inheritanceAwareMap, @Nullable Function<Component, String> function, int n2) {
            this.flatteners = InheritanceAwareMap.builder(inheritanceAwareMap).strict(true);
            this.unknownHandler = function;
            this.maxNestedDepth = n2;
        }

        @Override
        @NotNull
        public ComponentFlattener build() {
            return new ComponentFlattenerImpl((InheritanceAwareMap)this.flatteners.build(), this.unknownHandler, this.maxNestedDepth);
        }

        @Override
        public <T extends Component> @NotNull ComponentFlattener.Builder mapper(@NotNull Class<T> clazz, @NotNull Function<T, String> function) {
            this.flatteners.put(clazz, (componentFlattenerImpl, component, flattenerListener, n2, n3) -> flattenerListener.component((String)function.apply(component)));
            return this;
        }

        @Override
        public <T extends Component> @NotNull ComponentFlattener.Builder complexMapper(@NotNull Class<T> clazz, @NotNull BiConsumer<T, Consumer<Component>> biConsumer) {
            this.flatteners.put(clazz, (componentFlattenerImpl, component2, flattenerListener, n2, n3) -> biConsumer.accept(component2, component -> componentFlattenerImpl.flatten0(component, flattenerListener, n2, n3 + 1)));
            return this;
        }

        @Override
        public @NotNull ComponentFlattener.Builder unknownMapper(@Nullable Function<Component, String> function) {
            this.unknownHandler = function;
            return this;
        }

        @Override
        @NotNull
        public ComponentFlattener.Builder nestingLimit(@Range(from=1L, to=0x7FFFFFFFL) int n2) {
            if (n2 != -1 && n2 < 1) {
                throw new IllegalArgumentException("limit must be positive or ComponentFlattener.NO_NESTING_LIMIT");
            }
            this.maxNestedDepth = n2;
            return this;
        }
    }
}

