/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.event;

import java.util.Objects;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.dialog.DialogLike;
import me.ulrich.clans.library.kyori.adventure.internal.Internals;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.nbt.api.BinaryTagHolder;
import me.ulrich.clans.library.kyori.adventure.text.event.ClickEvent;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

abstract class PayloadImpl
implements ClickEvent.Payload {
    PayloadImpl() {
    }

    public String toString() {
        return Internals.toString(this);
    }

    static final class CustomImpl
    extends PayloadImpl
    implements ClickEvent.Payload.Custom {
        private final Key key;
        private final BinaryTagHolder nbt;

        CustomImpl(@NotNull Key key, @NotNull BinaryTagHolder binaryTagHolder) {
            this.key = key;
            this.nbt = binaryTagHolder;
        }

        @Override
        @NotNull
        public Key key() {
            return this.key;
        }

        @Override
        @NotNull
        public String data() {
            return this.nbt.string();
        }

        @Override
        @NotNull
        public BinaryTagHolder nbt() {
            return this.nbt;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("nbt", this.nbt));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CustomImpl customImpl = (CustomImpl)object;
            return Objects.equals(this.key, customImpl.key) && Objects.equals(this.nbt, customImpl.nbt);
        }

        public int hashCode() {
            int n2 = this.key.hashCode();
            n2 = 31 * n2 + this.nbt.hashCode();
            return n2;
        }
    }

    static final class DialogImpl
    extends PayloadImpl
    implements ClickEvent.Payload.Dialog {
        private final DialogLike dialogLike;

        DialogImpl(@NotNull DialogLike dialogLike) {
            this.dialogLike = dialogLike;
        }

        @Override
        @NotNull
        public DialogLike dialog() {
            return this.dialogLike;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("dialog", this.dialogLike));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DialogImpl dialogImpl = (DialogImpl)object;
            return Objects.equals(this.dialogLike, dialogImpl.dialogLike);
        }

        public int hashCode() {
            return this.dialogLike.hashCode();
        }
    }

    static final class IntImpl
    extends PayloadImpl
    implements ClickEvent.Payload.Int {
        private final int integer;

        IntImpl(int n2) {
            this.integer = n2;
        }

        @Override
        public int integer() {
            return this.integer;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("integer", this.integer));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IntImpl intImpl = (IntImpl)object;
            return Objects.equals(this.integer, intImpl.integer);
        }

        public int hashCode() {
            return this.integer;
        }
    }

    static final class TextImpl
    extends PayloadImpl
    implements ClickEvent.Payload.Text {
        private final String value;

        TextImpl(@NotNull String string) {
            this.value = string;
        }

        @Override
        @NotNull
        public String value() {
            return this.value;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("value", this.value));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TextImpl textImpl = (TextImpl)object;
            return Objects.equals(this.value, textImpl.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

