/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.TextComponent;
import me.ulrich.clans.library.kyori.adventure.text.TextComponentImpl;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponent;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponentRenderer;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualComponentImpl<C>
extends TextComponentImpl
implements VirtualComponent {
    private final Class<C> contextType;
    private final VirtualComponentRenderer<C> renderer;

    static <C> VirtualComponent createVirtual(@NotNull Class<C> clazz, @NotNull VirtualComponentRenderer<C> virtualComponentRenderer) {
        return VirtualComponentImpl.createVirtual(clazz, virtualComponentRenderer, Collections.emptyList(), Style.empty());
    }

    static <C> VirtualComponent createVirtual(@NotNull Class<C> clazz, @NotNull VirtualComponentRenderer<C> virtualComponentRenderer, List<? extends ComponentLike> list, Style style) {
        List<Component> list2 = ComponentLike.asComponents(list, IS_NOT_EMPTY);
        return new VirtualComponentImpl<C>(list2, style, "", clazz, virtualComponentRenderer);
    }

    private VirtualComponentImpl(@NotNull List<Component> list, @NotNull Style style, @NotNull String string, @NotNull Class<C> clazz, @NotNull VirtualComponentRenderer<C> virtualComponentRenderer) {
        super(list, style, string);
        this.contextType = clazz;
        this.renderer = virtualComponentRenderer;
    }

    @Override
    VirtualComponent create0(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull String string) {
        return new VirtualComponentImpl<C>(ComponentLike.asComponents(list, IS_NOT_EMPTY), style, string, this.contextType, this.renderer);
    }

    @NotNull
    public Class<C> contextType() {
        return this.contextType;
    }

    @NotNull
    public VirtualComponentRenderer<C> renderer() {
        return this.renderer;
    }

    @Override
    @NotNull
    public String content() {
        return this.renderer.fallbackString();
    }

    @Override
    @NotNull
    public TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VirtualComponentImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        VirtualComponentImpl virtualComponentImpl = (VirtualComponentImpl)object;
        return Objects.equals(this.contextType, virtualComponentImpl.contextType) && Objects.equals(this.renderer, virtualComponentImpl.renderer);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.contextType.hashCode();
        n2 = 31 * n2 + this.renderer.hashCode();
        return n2;
    }

    static final class BuilderImpl<C>
    extends TextComponentImpl.BuilderImpl {
        private final Class<C> contextType;
        private final VirtualComponentRenderer<C> renderer;

        BuilderImpl(VirtualComponentImpl<C> virtualComponentImpl) {
            super(virtualComponentImpl);
            this.contextType = virtualComponentImpl.contextType();
            this.renderer = virtualComponentImpl.renderer();
        }

        @Override
        @NotNull
        public TextComponent build() {
            return VirtualComponentImpl.createVirtual(this.contextType, this.renderer, this.children, this.buildStyle());
        }
    }
}

