/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.text.BuildableComponent;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentBuilder;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.ScopedComponent;
import me.ulrich.clans.library.kyori.adventure.text.TranslationArgument;
import me.ulrich.clans.library.kyori.adventure.translation.Translatable;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TranslatableComponent
extends BuildableComponent<TranslatableComponent, Builder>,
ScopedComponent<TranslatableComponent> {
    @NotNull
    public String key();

    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent key(@NotNull Translatable translatable) {
        return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
    }

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent key(@NotNull String var1);

    @Deprecated
    @NotNull
    public List<Component> args();

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent args(ComponentLike ... componentLikeArray) {
        return this.arguments(componentLikeArray);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent args(@NotNull List<? extends ComponentLike> list) {
        return this.arguments(list);
    }

    @NotNull
    public List<TranslationArgument> arguments();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent arguments(ComponentLike ... var1);

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent arguments(@NotNull List<? extends ComponentLike> var1);

    @Nullable
    public String fallback();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent fallback(@Nullable String var1);

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("key", this.key()), ExaminableProperty.of("arguments", this.arguments()), ExaminableProperty.of("fallback", this.fallback())), BuildableComponent.super.examinableProperties());
    }

    public static interface Builder
    extends ComponentBuilder<TranslatableComponent, Builder> {
        @Contract(pure=true)
        @NotNull
        default public Builder key(@NotNull Translatable translatable) {
            return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull String var1);

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(@NotNull ComponentBuilder<?, ?> componentBuilder) {
            return this.arguments(componentBuilder);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(ComponentBuilder<?, ?> ... componentBuilderArray) {
            return this.arguments(componentBuilderArray);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(@NotNull Component component) {
            return this.arguments(component);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(ComponentLike ... componentLikeArray) {
            return this.arguments(componentLikeArray);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(@NotNull List<? extends ComponentLike> list) {
            return this.arguments(list);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder arguments(ComponentLike ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder arguments(@NotNull List<? extends ComponentLike> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder fallback(@Nullable String var1);
    }
}

