/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import me.ulrich.clans.library.kyori.adventure.internal.Internals;
import me.ulrich.clans.library.kyori.adventure.text.AbstractComponent;
import me.ulrich.clans.library.kyori.adventure.text.AbstractComponentBuilder;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.ObjectComponent;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.object.ObjectContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectComponentImpl
extends AbstractComponent
implements ObjectComponent {
    private final ObjectContents contents;

    private ObjectComponentImpl(@NotNull List<Component> list, @NotNull Style style, @NotNull ObjectContents objectContents) {
        super(list, style);
        this.contents = objectContents;
    }

    @Override
    @NotNull
    public ObjectContents contents() {
        return this.contents;
    }

    @Override
    @NotNull
    public ObjectComponent contents(@NotNull ObjectContents objectContents) {
        return ObjectComponentImpl.create(this.children, this.style, objectContents);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectComponent)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ObjectComponentImpl objectComponentImpl = (ObjectComponentImpl)object;
        return Objects.equals(this.contents, objectComponentImpl.contents());
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.contents.hashCode();
        return n2;
    }

    @Override
    public String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public ObjectComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @NotNull
    static ObjectComponentImpl create(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull ObjectContents objectContents) {
        return new ObjectComponentImpl(ComponentLike.asComponents(list, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(objectContents, "contents"));
    }

    @Override
    @NotNull
    public ObjectComponent children(@NotNull List<? extends ComponentLike> list) {
        return ObjectComponentImpl.create(list, this.style, this.contents);
    }

    @Override
    @NotNull
    public ObjectComponent style(@NotNull Style style) {
        return ObjectComponentImpl.create(this.children, style, this.contents);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<ObjectComponent, ObjectComponent.Builder>
    implements ObjectComponent.Builder {
        private ObjectContents objectContents;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull ObjectComponent objectComponent) {
            super(objectComponent);
            this.objectContents = objectComponent.contents();
        }

        @Override
        @NotNull
        public ObjectComponent.Builder contents(@NotNull ObjectContents objectContents) {
            this.objectContents = Objects.requireNonNull(objectContents, "contents");
            return this;
        }

        @Override
        @NotNull
        public ObjectComponent build() {
            if (this.objectContents == null) {
                throw new IllegalStateException("contents must be set");
            }
            return ObjectComponentImpl.create(this.children, this.buildStyle(), this.objectContents);
        }
    }
}

