/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text;

import java.util.function.Function;
import java.util.function.Predicate;
import me.ulrich.clans.library.kyori.adventure.builder.AbstractBuilder;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.JoinConfigurationImpl;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.util.Buildable;
import me.ulrich.clans.library.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface JoinConfiguration
extends Buildable<JoinConfiguration, Builder>,
Examinable {
    @NotNull
    public static Builder builder() {
        return new JoinConfigurationImpl.BuilderImpl();
    }

    @NotNull
    public static JoinConfiguration noSeparators() {
        return JoinConfigurationImpl.NULL;
    }

    @NotNull
    public static JoinConfiguration newlines() {
        return JoinConfigurationImpl.STANDARD_NEW_LINES;
    }

    @NotNull
    public static JoinConfiguration spaces() {
        return JoinConfigurationImpl.STANDARD_SPACES;
    }

    @NotNull
    public static JoinConfiguration commas(boolean bl) {
        return bl ? JoinConfigurationImpl.STANDARD_COMMA_SPACE_SEPARATED : JoinConfigurationImpl.STANDARD_COMMA_SEPARATED;
    }

    @NotNull
    public static JoinConfiguration arrayLike() {
        return JoinConfigurationImpl.STANDARD_ARRAY_LIKE;
    }

    @NotNull
    public static JoinConfiguration separator(@Nullable ComponentLike componentLike) {
        if (componentLike == null) {
            return JoinConfigurationImpl.NULL;
        }
        return (JoinConfiguration)JoinConfiguration.builder().separator(componentLike).build();
    }

    @NotNull
    public static JoinConfiguration separators(@Nullable ComponentLike componentLike, @Nullable ComponentLike componentLike2) {
        if (componentLike == null && componentLike2 == null) {
            return JoinConfigurationImpl.NULL;
        }
        return (JoinConfiguration)JoinConfiguration.builder().separator(componentLike).lastSeparator(componentLike2).build();
    }

    @Nullable
    public Component prefix();

    @Nullable
    public Component suffix();

    @Nullable
    public Component separator();

    @Nullable
    public Component lastSeparator();

    @Nullable
    public Component lastSeparatorIfSerial();

    @NotNull
    public Function<ComponentLike, Component> convertor();

    @NotNull
    public Predicate<ComponentLike> predicate();

    @NotNull
    public Style parentStyle();

    public static interface Builder
    extends AbstractBuilder<JoinConfiguration>,
    Buildable.Builder<JoinConfiguration> {
        @Contract(value="_ -> this")
        @NotNull
        public Builder prefix(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder suffix(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder separator(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder lastSeparator(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder lastSeparatorIfSerial(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder convertor(@NotNull Function<ComponentLike, Component> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder predicate(@NotNull Predicate<ComponentLike> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder parentStyle(@NotNull Style var1);
    }
}

