/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ComponentLike {
    @NotNull
    public static List<Component> asComponents(@NotNull List<? extends ComponentLike> list) {
        return ComponentLike.asComponents(list, null);
    }

    @NotNull
    public static List<Component> asComponents(@NotNull List<? extends ComponentLike> list, @Nullable Predicate<? super Component> predicate) {
        Objects.requireNonNull(list, "likes");
        int n2 = list.size();
        if (n2 == 0) {
            return Collections.emptyList();
        }
        @Nullable ArrayList<Component> arrayList = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            @Nullable ComponentLike componentLike = list.get(i2);
            if (componentLike == null) {
                throw new NullPointerException("likes[" + i2 + "]");
            }
            Component component = componentLike.asComponent();
            if (predicate != null && !predicate.test(component)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Component>(n2);
            }
            arrayList.add(component);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    @Nullable
    public static Component unbox(@Nullable ComponentLike componentLike) {
        return componentLike != null ? componentLike.asComponent() : null;
    }

    @Contract(pure=true)
    @NotNull
    public Component asComponent();
}

