/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.platform.bukkit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.MinecraftReflection;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MinecraftComponentSerializer
implements ComponentSerializer<Component, Component, Object> {
    private static final MinecraftComponentSerializer INSTANCE;
    @Nullable
    private static final Class<?> CLASS_JSON_DESERIALIZER;
    @Nullable
    private static final Class<?> CLASS_JSON_ELEMENT;
    @Nullable
    private static final Class<?> CLASS_JSON_OPS;
    @Nullable
    private static final Class<?> CLASS_JSON_PARSER;
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT;
    @Nullable
    private static final Class<?> CLASS_COMPONENT_SERIALIZATION;
    @Nullable
    private static final Class<?> CLASS_CRAFT_REGISTRY;
    @Nullable
    private static final Class<?> CLASS_HOLDERLOOKUP_PROVIDER;
    @Nullable
    private static final Class<?> CLASS_REGISTRY_ACCESS;
    @Nullable
    private static final MethodHandle PARSE_JSON;
    @Nullable
    private static final MethodHandle GET_REGISTRY;
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR;
    private static final Object JSON_OPS_INSTANCE;
    private static final Object JSON_PARSER_INSTANCE;
    private static final Object MC_TEXT_GSON;
    private static final Object REGISTRY_ACCESS;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE_TREE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE_TREE;
    private static final MethodHandle COMPONENTSERIALIZATION_CODEC_ENCODE;
    private static final MethodHandle COMPONENTSERIALIZATION_CODEC_DECODE;
    private static final MethodHandle CREATE_SERIALIZATION_CONTEXT;
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @NotNull
    public static MinecraftComponentSerializer get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Object object) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            Object object2;
            if (TEXT_SERIALIZER_SERIALIZE_TREE != null) {
                object2 = TEXT_SERIALIZER_SERIALIZE_TREE.invoke(object);
            } else if (MC_TEXT_GSON != null) {
                object2 = ((Gson)MC_TEXT_GSON).toJsonTree(object);
            } else {
                if (COMPONENTSERIALIZATION_CODEC_ENCODE != null && CREATE_SERIALIZATION_CONTEXT != null) {
                    Object object3 = CREATE_SERIALIZATION_CONTEXT.bindTo(REGISTRY_ACCESS).invoke(JSON_OPS_INSTANCE);
                    Object object4 = COMPONENTSERIALIZATION_CODEC_ENCODE.invoke(object, object3, null);
                    Method method = object4.getClass().getMethod("getOrThrow", Function.class);
                    Object object5 = method.invoke(object4, RuntimeException::new);
                    return BukkitComponentSerializer.gson().serializer().fromJson(object5.toString(), Component.class);
                }
                return BukkitComponentSerializer.gson().deserialize(TEXT_SERIALIZER_SERIALIZE.invoke(object));
            }
            return BukkitComponentSerializer.gson().serializer().fromJson(object2.toString(), Component.class);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Component component) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (TEXT_SERIALIZER_DESERIALIZE_TREE != null || MC_TEXT_GSON != null) {
            JsonElement jsonElement = BukkitComponentSerializer.gson().serializer().toJsonTree(component);
            try {
                if (TEXT_SERIALIZER_DESERIALIZE_TREE != null) {
                    Object object = PARSE_JSON.invoke(JSON_PARSER_INSTANCE, jsonElement.toString());
                    return TEXT_SERIALIZER_DESERIALIZE_TREE.invoke(object);
                }
                return ((Gson)MC_TEXT_GSON).fromJson(jsonElement, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable throwable) {
                throw new UnsupportedOperationException(throwable);
            }
        }
        try {
            if (COMPONENTSERIALIZATION_CODEC_DECODE != null && CREATE_SERIALIZATION_CONTEXT != null) {
                Object object = CREATE_SERIALIZATION_CONTEXT.bindTo(REGISTRY_ACCESS).invoke(JSON_OPS_INSTANCE);
                Object object2 = COMPONENTSERIALIZATION_CODEC_DECODE.invoke(object, BukkitComponentSerializer.gson().serializeToTree(component));
                Method method = object2.getClass().getMethod("getOrThrow", Function.class);
                Object object3 = method.invoke(object2, RuntimeException::new);
                Method method2 = object3.getClass().getMethod("getFirst", new Class[0]);
                return method2.invoke(object3, new Object[0]);
            }
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(component));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    static {
        MethodHandle methodHandle;
        MethodHandle methodHandle2;
        MethodHandle methodHandle3;
        MethodHandle methodHandle4;
        MethodHandle methodHandle5;
        MethodHandle methodHandle6;
        MethodHandle methodHandle7;
        Object object;
        Object var2_2;
        Object object2;
        Object object3;
        block18: {
            INSTANCE = new MinecraftComponentSerializer();
            CLASS_JSON_DESERIALIZER = MinecraftReflection.findClass("com.goo".concat("gle.gson.JsonDeserializer"));
            CLASS_JSON_ELEMENT = MinecraftReflection.findClass("com.goo".concat("gle.gson.JsonElement"));
            CLASS_JSON_OPS = MinecraftReflection.findClass("com.mo".concat("jang.serialization.JsonOps"));
            CLASS_JSON_PARSER = MinecraftReflection.findClass("com.goo".concat("gle.gson.JsonParser"));
            CLASS_CHAT_COMPONENT = MinecraftReflection.findClass(MinecraftReflection.findNmsClassName("IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.Component"));
            CLASS_COMPONENT_SERIALIZATION = MinecraftReflection.findClass(MinecraftReflection.findMcClassName("network.chat.ComponentSerialization"));
            CLASS_CRAFT_REGISTRY = MinecraftReflection.findCraftClass("CraftRegistry");
            CLASS_HOLDERLOOKUP_PROVIDER = MinecraftReflection.findClass(MinecraftReflection.findMcClassName("core.HolderLookup$Provider"), MinecraftReflection.findMcClassName("core.HolderLookup$a"));
            CLASS_REGISTRY_ACCESS = MinecraftReflection.findClass(MinecraftReflection.findMcClassName("core.IRegistryCustom"), MinecraftReflection.findMcClassName("core.RegistryAccess"));
            PARSE_JSON = MinecraftReflection.findMethod(CLASS_JSON_PARSER, "parse", CLASS_JSON_ELEMENT, String.class);
            GET_REGISTRY = MinecraftReflection.findStaticMethod(CLASS_CRAFT_REGISTRY, "getMinecraftRegistry", CLASS_REGISTRY_ACCESS, new Class[0]);
            INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
            object3 = null;
            object2 = null;
            var2_2 = null;
            object = null;
            methodHandle7 = null;
            methodHandle6 = null;
            methodHandle5 = null;
            methodHandle4 = null;
            methodHandle3 = null;
            methodHandle2 = null;
            methodHandle = null;
            try {
                GenericDeclaration genericDeclaration;
                Object object4;
                Object object5;
                Object object6;
                if (CLASS_JSON_OPS != null) {
                    object6 = CLASS_JSON_OPS.getField("INSTANCE");
                    ((Field)object6).setAccessible(true);
                    object2 = ((Field)object6).get(null);
                }
                if (CLASS_JSON_PARSER != null) {
                    var2_2 = CLASS_JSON_PARSER.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (CLASS_CHAT_COMPONENT == null) break block18;
                object = object6 = GET_REGISTRY != null ? GET_REGISTRY.invoke() : null;
                Class<?> clazz2 = Arrays.stream(CLASS_CHAT_COMPONENT.getClasses()).filter(clazz -> {
                    if (CLASS_JSON_DESERIALIZER != null) {
                        return CLASS_JSON_DESERIALIZER.isAssignableFrom((Class<?>)clazz);
                    }
                    for (Class<?> clazz2 : clazz.getInterfaces()) {
                        if (!clazz2.getSimpleName().equals("JsonDeserializer")) continue;
                        return true;
                    }
                    return false;
                }).findAny().orElse(MinecraftReflection.findNmsClass("ChatSerializer"));
                if (clazz2 != null && (object5 = (Field)Arrays.stream(clazz2.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(Gson.class)).findFirst().orElse(null)) != null) {
                    ((Field)object5).setAccessible(true);
                    object3 = ((Field)object5).get(null);
                }
                object5 = new ArrayList();
                if (clazz2 != null) {
                    object5.add(clazz2);
                }
                object5.addAll(Arrays.asList(CLASS_CHAT_COMPONENT.getClasses()));
                AccessibleObject[] accessibleObjectArray = object5.iterator();
                while (accessibleObjectArray.hasNext()) {
                    Class clazz3 = (Class)accessibleObjectArray.next();
                    Method[] methodArray = clazz3.getDeclaredMethods();
                    Method accessibleObject = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    object4 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(String.class)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    genericDeclaration = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(CLASS_JSON_ELEMENT)).findFirst().orElse(null);
                    Method method2 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(CLASS_JSON_ELEMENT)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    Method method3 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 2).filter(method -> method.getParameterTypes()[0].equals(CLASS_JSON_ELEMENT)).filter(method -> method.getParameterTypes()[1].isInstance(object6)).findFirst().orElse(null);
                    Method method4 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(CLASS_JSON_ELEMENT)).filter(method -> method.getParameterCount() == 2).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).filter(method -> method.getParameterTypes()[1].isInstance(object6)).findFirst().orElse(null);
                    if (accessibleObject != null) {
                        methodHandle7 = MinecraftReflection.lookup().unreflect(accessibleObject);
                    }
                    if (object4 != null) {
                        methodHandle6 = MinecraftReflection.lookup().unreflect((Method)object4);
                    }
                    if (genericDeclaration != null) {
                        methodHandle5 = MinecraftReflection.lookup().unreflect((Method)genericDeclaration);
                    } else if (method3 != null) {
                        method3.setAccessible(true);
                        methodHandle5 = MethodHandles.insertArguments(MinecraftReflection.lookup().unreflect(method3), 1, object6);
                    }
                    if (method2 != null) {
                        methodHandle4 = MinecraftReflection.lookup().unreflect(method2);
                        continue;
                    }
                    if (method4 == null) continue;
                    method4.setAccessible(true);
                    methodHandle4 = MethodHandles.insertArguments(MinecraftReflection.lookup().unreflect(method4), 1, object6);
                }
                if (object6 != null && CLASS_HOLDERLOOKUP_PROVIDER != null) {
                    for (AccessibleObject accessibleObject : CLASS_HOLDERLOOKUP_PROVIDER.getDeclaredMethods()) {
                        ((Method)accessibleObject).setAccessible(true);
                        if (((Method)accessibleObject).getParameterCount() != 1 || !((Method)accessibleObject).getParameterTypes()[0].getSimpleName().equals("DynamicOps") || !((Method)accessibleObject).getReturnType().getSimpleName().contains("RegistryOps")) continue;
                        methodHandle = MinecraftReflection.lookup().unreflect((Method)accessibleObject);
                        break;
                    }
                }
                if (CLASS_COMPONENT_SERIALIZATION == null) break block18;
                for (AccessibleObject accessibleObject : CLASS_COMPONENT_SERIALIZATION.getDeclaredFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !((Field)accessibleObject).getType().getSimpleName().equals("Codec")) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    object4 = ((Field)accessibleObject).get(null);
                    genericDeclaration = object4.getClass();
                    for (Method method5 : genericDeclaration.getDeclaredMethods()) {
                        if (method5.getName().equals("decode")) {
                            methodHandle2 = MinecraftReflection.lookup().unreflect(method5).bindTo(object4);
                            continue;
                        }
                        if (!method5.getName().equals("encode")) continue;
                        methodHandle3 = MinecraftReflection.lookup().unreflect(method5).bindTo(object4);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", throwable));
            }
        }
        MC_TEXT_GSON = object3;
        JSON_OPS_INSTANCE = object2;
        JSON_PARSER_INSTANCE = var2_2;
        TEXT_SERIALIZER_DESERIALIZE = methodHandle7;
        TEXT_SERIALIZER_SERIALIZE = methodHandle6;
        TEXT_SERIALIZER_DESERIALIZE_TREE = methodHandle5;
        TEXT_SERIALIZER_SERIALIZE_TREE = methodHandle4;
        COMPONENTSERIALIZATION_CODEC_ENCODE = methodHandle3;
        COMPONENTSERIALIZATION_CODEC_DECODE = methodHandle2;
        CREATE_SERIALIZATION_CONTEXT = methodHandle;
        REGISTRY_ACCESS = object;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null || TEXT_SERIALIZER_DESERIALIZE_TREE != null && TEXT_SERIALIZER_SERIALIZE_TREE != null || COMPONENTSERIALIZATION_CODEC_ENCODE != null && COMPONENTSERIALIZATION_CODEC_DECODE != null && CREATE_SERIALIZATION_CONTEXT != null && JSON_OPS_INSTANCE != null;
    }
}

