/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.platform.bukkit;

import com.google.common.collect.ImmutableList;
import com.google.common.graph.MutableGraph;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import me.ulrich.clans.library.kyori.adventure.audience.Audience;
import me.ulrich.clans.library.kyori.adventure.identity.Identity;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.BukkitAudience;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.MinecraftReflection;
import me.ulrich.clans.library.kyori.adventure.platform.facet.FacetAudienceProvider;
import me.ulrich.clans.library.kyori.adventure.platform.facet.Knob;
import me.ulrich.clans.library.kyori.adventure.pointer.Pointered;
import me.ulrich.clans.library.kyori.adventure.text.flattener.ComponentFlattener;
import me.ulrich.clans.library.kyori.adventure.text.renderer.ComponentRenderer;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

final class BukkitAudiencesImpl
extends FacetAudienceProvider<CommandSender, BukkitAudience>
implements BukkitAudiences,
Listener {
    private static final Map<String, BukkitAudiences> INSTANCES;
    private final Plugin plugin;

    static Builder builder(@NotNull Plugin plugin) {
        return new Builder(plugin);
    }

    static BukkitAudiences instanceFor(@NotNull Plugin plugin) {
        return BukkitAudiencesImpl.builder(plugin).build();
    }

    BukkitAudiencesImpl(@NotNull Plugin plugin, @NotNull ComponentRenderer<Pointered> componentRenderer) {
        super(componentRenderer);
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        ConsoleCommandSender consoleCommandSender = this.plugin.getServer().getConsoleSender();
        this.addViewer(consoleCommandSender);
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.addViewer(player);
        }
        this.registerEvent(PlayerJoinEvent.class, EventPriority.LOWEST, playerJoinEvent -> this.addViewer(playerJoinEvent.getPlayer()));
        this.registerEvent(PlayerQuitEvent.class, EventPriority.MONITOR, playerQuitEvent -> this.removeViewer(playerQuitEvent.getPlayer()));
    }

    @Override
    @NotNull
    public Audience sender(@NotNull CommandSender commandSender) {
        if (commandSender instanceof Player) {
            return this.player((Player)commandSender);
        }
        if (commandSender instanceof ConsoleCommandSender) {
            return this.console();
        }
        if (commandSender instanceof ProxiedCommandSender) {
            return this.sender(((ProxiedCommandSender)commandSender).getCallee());
        }
        if (commandSender instanceof Entity || commandSender instanceof Block) {
            return Audience.empty();
        }
        return this.createAudience(Collections.singletonList(commandSender));
    }

    @Override
    @NotNull
    public Audience player(@NotNull Player player) {
        return super.player(player.getUniqueId());
    }

    @Override
    @NotNull
    protected BukkitAudience createAudience(@NotNull Collection<CommandSender> collection) {
        return new BukkitAudience(this.plugin, this, collection);
    }

    @Override
    public void close() {
        INSTANCES.remove(this.plugin.getName());
        super.close();
    }

    @Override
    @NotNull
    public ComponentFlattener flattener() {
        return BukkitComponentSerializer.FLATTENER;
    }

    private <T extends Event> void registerEvent(@NotNull Class<T> clazz, @NotNull EventPriority eventPriority, @NotNull Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "callback");
        this.plugin.getServer().getPluginManager().registerEvent(clazz, (Listener)this, eventPriority, (listener, event) -> consumer.accept(event), this.plugin, true);
    }

    static {
        Knob.OUT = string -> Bukkit.getLogger().log(Level.INFO, (String)string);
        Knob.ERR = (string, throwable) -> Bukkit.getLogger().log(Level.WARNING, (String)string, (Throwable)throwable);
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
    }

    static final class Builder
    implements BukkitAudiences.Builder {
        @NotNull
        private final Plugin plugin;
        private ComponentRenderer<Pointered> componentRenderer;

        Builder(@NotNull Plugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.componentRenderer(pointered -> pointered.getOrDefault(Identity.LOCALE, DEFAULT_LOCALE), GlobalTranslator.renderer());
        }

        @Override
        @NotNull
        public Builder componentRenderer(@NotNull ComponentRenderer<Pointered> componentRenderer) {
            this.componentRenderer = Objects.requireNonNull(componentRenderer, "component renderer");
            return this;
        }

        @Override
        public @NotNull BukkitAudiences.Builder partition(@NotNull Function<Pointered, ?> function) {
            Objects.requireNonNull(function, "partitionFunction");
            return this;
        }

        @Override
        @NotNull
        public BukkitAudiences build() {
            return INSTANCES.computeIfAbsent(this.plugin.getName(), string -> {
                this.softDepend("ViaVersion");
                return new BukkitAudiencesImpl(this.plugin, this.componentRenderer);
            });
        }

        private void softDepend(@NotNull String string) {
            ImmutableList immutableList;
            Object object;
            Field field;
            PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
            if (pluginDescriptionFile.getName().equals(string)) {
                return;
            }
            try {
                field = MinecraftReflection.needField(pluginDescriptionFile.getClass(), "softDepend");
                object = (List)field.get(pluginDescriptionFile);
                if (!object.contains(string)) {
                    immutableList = ImmutableList.builder().addAll((Iterable)object).add((Object)string).build();
                    field.set(pluginDescriptionFile, immutableList);
                }
            }
            catch (Throwable throwable) {
                Knob.logError(throwable, "Failed to inject softDepend in plugin.yml: %s %s", this.plugin, string);
            }
            try {
                field = this.plugin.getServer().getPluginManager();
                object = MinecraftReflection.needField(field.getClass(), "dependencyGraph");
                immutableList = (MutableGraph)((Field)object).get(field);
                immutableList.putEdge((Object)pluginDescriptionFile.getName(), (Object)string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

