/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.nbt;

import java.util.ArrayList;
import java.util.List;
import me.ulrich.clans.library.kyori.adventure.nbt.BinaryTag;
import me.ulrich.clans.library.kyori.adventure.nbt.BinaryTagType;
import me.ulrich.clans.library.kyori.adventure.nbt.BinaryTagTypes;
import me.ulrich.clans.library.kyori.adventure.nbt.ListBinaryTag;
import me.ulrich.clans.library.kyori.adventure.nbt.ListBinaryTagImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    @Nullable
    private List<BinaryTag> tags;
    private final boolean permitsHeterogeneity;
    private BinaryTagType<? extends BinaryTag> elementType;

    ListTagBuilder(boolean bl) {
        this(bl, BinaryTagTypes.END);
    }

    ListTagBuilder(boolean bl, BinaryTagType<? extends BinaryTag> binaryTagType) {
        this.permitsHeterogeneity = bl;
        this.elementType = binaryTagType;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(BinaryTag binaryTag) {
        this.elementType = ListBinaryTagImpl.validateTagType(binaryTag, this.elementType, this.permitsHeterogeneity);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(binaryTag);
        return this;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(Iterable<? extends T> iterable) {
        for (BinaryTag binaryTag : iterable) {
            this.add(binaryTag);
        }
        return this;
    }

    @Override
    @NotNull
    public ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.elementType, this.permitsHeterogeneity, new ArrayList<BinaryTag>(this.tags));
    }
}

