/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.nbt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.nbt.AbstractBinaryTag;
import me.ulrich.clans.library.kyori.adventure.nbt.BinaryTag;
import me.ulrich.clans.library.kyori.adventure.nbt.BinaryTagType;
import me.ulrich.clans.library.kyori.adventure.nbt.BinaryTagTypes;
import me.ulrich.clans.library.kyori.adventure.nbt.CompoundBinaryTag;
import me.ulrich.clans.library.kyori.adventure.nbt.ListBinaryTag;
import me.ulrich.clans.library.kyori.adventure.nbt.ListBinaryTag0;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@Debug.Renderer(text="\"ListBinaryTag[type=\" + this.type.toString() + \"]\"", childrenArray="this.tags.toArray()", hasChildren="!this.tags.isEmpty()")
final class ListBinaryTagImpl
extends AbstractBinaryTag
implements ListBinaryTag {
    static final ListBinaryTag EMPTY = new ListBinaryTagImpl(BinaryTagTypes.END, false, Collections.emptyList());
    private final List<BinaryTag> tags;
    private final boolean permitsHeterogeneity;
    private final BinaryTagType<? extends BinaryTag> elementType;
    private final int hashCode;

    ListBinaryTagImpl(BinaryTagType<? extends BinaryTag> binaryTagType, boolean bl, List<BinaryTag> list) {
        this.tags = Collections.unmodifiableList(list);
        this.permitsHeterogeneity = bl;
        this.elementType = binaryTagType;
        this.hashCode = list.hashCode();
    }

    @Override
    @NotNull
    public BinaryTagType<? extends BinaryTag> elementType() {
        return this.elementType;
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    @NotNull
    public BinaryTag get(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.tags.get(n2);
    }

    @Override
    @NotNull
    public ListBinaryTag set(int n2, @NotNull BinaryTag binaryTag, @Nullable Consumer<? super BinaryTag> consumer) {
        BinaryTagType<?> binaryTagType = ListBinaryTagImpl.validateTagType(binaryTag, this.elementType, this.permitsHeterogeneity);
        return this.edit(list -> {
            BinaryTag binaryTag2 = list.set(n2, binaryTag);
            if (consumer != null) {
                consumer.accept(binaryTag2);
            }
        }, binaryTagType);
    }

    @Override
    @NotNull
    public ListBinaryTag remove(int n2, @Nullable Consumer<? super BinaryTag> consumer) {
        return this.edit(list -> {
            BinaryTag binaryTag = (BinaryTag)list.remove(n2);
            if (consumer != null) {
                consumer.accept(binaryTag);
            }
        }, null);
    }

    @Override
    @NotNull
    public ListBinaryTag add(BinaryTag binaryTag) {
        BinaryTagType<?> binaryTagType = ListBinaryTagImpl.validateTagType(binaryTag, this.elementType, this.permitsHeterogeneity);
        return this.edit(list -> list.add(binaryTag), binaryTagType);
    }

    @Override
    @NotNull
    public ListBinaryTag add(Iterable<? extends BinaryTag> iterable) {
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return this;
        }
        BinaryTagType<?> binaryTagType = ListBinaryTagImpl.validateTagType(iterable, this.permitsHeterogeneity);
        return this.edit(list -> {
            for (BinaryTag binaryTag : iterable) {
                list.add(binaryTag);
            }
        }, binaryTagType);
    }

    static void noAddEnd(BinaryTag binaryTag) {
        if (binaryTag.type() == BinaryTagTypes.END) {
            throw new IllegalArgumentException(String.format("Cannot add a %s to a %s", BinaryTagTypes.END, BinaryTagTypes.LIST));
        }
    }

    static BinaryTagType<?> validateTagType(Iterable<? extends BinaryTag> iterable, boolean bl) {
        BinaryTagType<? extends BinaryTag> binaryTagType = null;
        for (BinaryTag binaryTag : iterable) {
            if (binaryTagType == null) {
                ListBinaryTagImpl.noAddEnd(binaryTag);
                binaryTagType = binaryTag.type();
                continue;
            }
            ListBinaryTagImpl.validateTagType(binaryTag, binaryTagType, bl);
            if (binaryTagType == binaryTag.type()) continue;
            binaryTagType = BinaryTagTypes.LIST_WILDCARD;
        }
        return binaryTagType;
    }

    static BinaryTagType<?> validateTagType(BinaryTag binaryTag, BinaryTagType<? extends BinaryTag> binaryTagType, boolean bl) {
        ListBinaryTagImpl.noAddEnd(binaryTag);
        if (binaryTagType == BinaryTagTypes.END) {
            return binaryTag.type();
        }
        if (binaryTag.type() != binaryTagType && !bl) {
            throw new IllegalArgumentException(String.format("Trying to add tag of type %s to list of %s", binaryTag.type(), binaryTagType));
        }
        return binaryTag.type() != binaryTagType ? BinaryTagTypes.LIST_WILDCARD : binaryTagType;
    }

    private ListBinaryTag edit(Consumer<List<BinaryTag>> consumer, @Nullable BinaryTagType<? extends BinaryTag> binaryTagType) {
        ArrayList<BinaryTag> arrayList = new ArrayList<BinaryTag>(this.tags);
        consumer.accept(arrayList);
        BinaryTagType<? extends BinaryTag> binaryTagType2 = this.elementType;
        if (binaryTagType != null) {
            binaryTagType2 = binaryTagType;
        }
        return new ListBinaryTagImpl(binaryTagType2, this.permitsHeterogeneity, new ArrayList<BinaryTag>(arrayList));
    }

    @Override
    @NotNull
    public Stream<BinaryTag> stream() {
        return this.tags.stream();
    }

    @Override
    @NotNull
    public ListBinaryTag unwrapHeterogeneity() {
        if (!this.permitsHeterogeneity) {
            if (this.elementType != BinaryTagTypes.COMPOUND) {
                return new ListBinaryTagImpl(this.elementType, true, this.tags);
            }
            List<BinaryTag> list = null;
            ListIterator<BinaryTag> listIterator = this.tags.listIterator();
            while (listIterator.hasNext()) {
                BinaryTag binaryTag = listIterator.next();
                BinaryTag binaryTag2 = ListBinaryTag0.unbox((CompoundBinaryTag)binaryTag);
                if (binaryTag2 != binaryTag && list == null) {
                    list = new ArrayList<BinaryTag>(this.tags.size());
                    int n2 = listIterator.nextIndex() - 1;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        list.add(this.tags.get(i2));
                    }
                }
                if (list == null) continue;
                list.add(binaryTag2);
            }
            return new ListBinaryTagImpl(list == null ? BinaryTagTypes.COMPOUND : BinaryTagTypes.LIST_WILDCARD, true, list == null ? this.tags : list);
        }
        return this;
    }

    @Override
    @NotNull
    public ListBinaryTag wrapHeterogeneity() {
        if (this.elementType != BinaryTagTypes.LIST_WILDCARD) {
            return this;
        }
        ArrayList<BinaryTag> arrayList = new ArrayList<BinaryTag>(this.tags.size());
        for (BinaryTag binaryTag : this.tags) {
            arrayList.add(ListBinaryTag0.box(binaryTag));
        }
        return new ListBinaryTagImpl(BinaryTagTypes.COMPOUND, false, arrayList);
    }

    @Override
    @NotNull
    public Iterator<BinaryTag> iterator() {
        final Iterator<BinaryTag> iterator = this.tags.iterator();
        return new Iterator<BinaryTag>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BinaryTag next() {
                return (BinaryTag)iterator.next();
            }

            @Override
            public void forEachRemaining(Consumer<? super BinaryTag> consumer) {
                iterator.forEachRemaining(consumer);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super BinaryTag> consumer) {
        this.tags.forEach(consumer);
    }

    @Override
    public Spliterator<BinaryTag> spliterator() {
        return Spliterators.spliterator(this.tags, 1040);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ListBinaryTagImpl && this.tags.equals(((ListBinaryTagImpl)object).tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags), ExaminableProperty.of("type", this.elementType));
    }
}

