/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.nbt;

import me.ulrich.clans.library.kyori.adventure.nbt.StringTagParseException;

final class CharBuffer {
    private final CharSequence sequence;
    private int index;

    CharBuffer(CharSequence charSequence) {
        this.sequence = charSequence;
    }

    public char peek() {
        return this.sequence.charAt(this.index);
    }

    public char peek(int n2) {
        return this.sequence.charAt(this.index + n2);
    }

    public char take() {
        return this.sequence.charAt(this.index++);
    }

    public boolean advance() {
        ++this.index;
        return this.hasMore();
    }

    public boolean hasMore() {
        return this.index < this.sequence.length();
    }

    public boolean hasMore(int n2) {
        return this.index + n2 < this.sequence.length();
    }

    public CharSequence takeUntil(char c2) {
        c2 = Character.toLowerCase(c2);
        int n2 = -1;
        for (int i2 = this.index; i2 < this.sequence.length(); ++i2) {
            if (this.sequence.charAt(i2) == '\\') {
                ++i2;
                continue;
            }
            if (Character.toLowerCase(this.sequence.charAt(i2)) != c2) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            throw this.makeError("No occurrence of " + c2 + " was found");
        }
        CharSequence charSequence = this.sequence.subSequence(this.index, n2);
        this.index = n2 + 1;
        return charSequence;
    }

    public CharBuffer expect(char c2) {
        this.skipWhitespace();
        if (!this.hasMore()) {
            throw this.makeError("Expected character '" + c2 + "' but got EOF");
        }
        if (this.peek() != c2) {
            throw this.makeError("Expected character '" + c2 + "' but got '" + this.peek() + "'");
        }
        this.take();
        return this;
    }

    public boolean takeIf(char c2) {
        this.skipWhitespace();
        if (this.hasMore() && this.peek() == c2) {
            this.advance();
            return true;
        }
        return false;
    }

    public CharBuffer skipWhitespace() {
        while (this.hasMore() && Character.isWhitespace(this.peek())) {
            this.advance();
        }
        return this;
    }

    public StringTagParseException makeError(String string) {
        return new StringTagParseException(string, this.sequence, this.index);
    }
}

