/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.nbt;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.nbt.ArrayBinaryTagImpl;
import me.ulrich.clans.library.kyori.adventure.nbt.ByteArrayBinaryTag;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"byte[\" + this.value.length + \"]\"", childrenArray="this.value", hasChildren="this.value.length > 0")
final class ByteArrayBinaryTagImpl
extends ArrayBinaryTagImpl
implements ByteArrayBinaryTag {
    final byte[] value;

    ByteArrayBinaryTagImpl(byte[] byArray) {
        this.value = Arrays.copyOf(byArray, byArray.length);
    }

    @Override
    public byte @NotNull [] value() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public byte get(int n2) {
        ByteArrayBinaryTagImpl.checkIndex(n2, this.value.length);
        return this.value[n2];
    }

    static byte[] value(ByteArrayBinaryTag byteArrayBinaryTag) {
        return byteArrayBinaryTag instanceof ByteArrayBinaryTagImpl ? ((ByteArrayBinaryTagImpl)byteArrayBinaryTag).value : byteArrayBinaryTag.value();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteArrayBinaryTagImpl byteArrayBinaryTagImpl = (ByteArrayBinaryTagImpl)object;
        return Arrays.equals(this.value, byteArrayBinaryTagImpl.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.value));
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ByteArrayBinaryTagImpl.this.value.length - 1;
            }

            @Override
            public Byte next() {
                return ByteArrayBinaryTagImpl.this.value[this.index++];
            }
        };
    }
}

