/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.key;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.key.InvalidKeyException;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;

final class KeyImpl
implements Key {
    static final Comparator<? super Key> COMPARATOR = Comparator.comparing(Key::value).thenComparing(Key::namespace);
    @RegExp
    static final String NAMESPACE_PATTERN = "[a-z0-9_\\-.]+";
    @RegExp
    static final String VALUE_PATTERN = "[a-z0-9_\\-./]+";
    private final String namespace;
    private final String value;

    KeyImpl(@NotNull String string, @NotNull String string2) {
        KeyImpl.checkError("namespace", string, string, string2, Key.checkNamespace(string), NAMESPACE_PATTERN);
        KeyImpl.checkError("value", string2, string, string2, Key.checkValue(string2), VALUE_PATTERN);
        this.namespace = Objects.requireNonNull(string, "namespace");
        this.value = Objects.requireNonNull(string2, "value");
    }

    private static void checkError(String string, String string2, String string3, String string4, OptionalInt optionalInt, String string5) {
        if (optionalInt.isPresent()) {
            int n2 = optionalInt.getAsInt();
            char c2 = string2.charAt(n2);
            throw new InvalidKeyException(string3, string4, String.format("Non " + string5 + " character in %s of Key[%s] at index %d ('%s', bytes: %s)", string, KeyImpl.asString(string3, string4), n2, Character.valueOf(c2), Arrays.toString(String.valueOf(c2).getBytes(StandardCharsets.UTF_8))));
        }
    }

    static boolean allowedInNamespace(char c2) {
        return c2 == '_' || c2 == '-' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '.';
    }

    static boolean allowedInValue(char c2) {
        return c2 == '_' || c2 == '-' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '/';
    }

    @Override
    @NotNull
    public String namespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return KeyImpl.asString(this.namespace, this.value);
    }

    @NotNull
    private static String asString(@NotNull String string, @NotNull String string2) {
        return string + ':' + string2;
    }

    @NotNull
    public String toString() {
        return this.asString();
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace), ExaminableProperty.of("value", this.value));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        Key key = (Key)object;
        return Objects.equals(this.namespace, key.namespace()) && Objects.equals(this.value, key.value());
    }

    public int hashCode() {
        int n2 = this.namespace.hashCode();
        n2 = 31 * n2 + this.value.hashCode();
        return n2;
    }

    @Override
    public int compareTo(@NotNull Key key) {
        return Key.super.compareTo(key);
    }
}

