/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.key;

import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.key.KeyImpl;
import me.ulrich.clans.library.kyori.adventure.key.KeyPattern;
import me.ulrich.clans.library.kyori.adventure.key.Keyed;
import me.ulrich.clans.library.kyori.adventure.key.Namespaced;
import me.ulrich.clans.library.kyori.examination.Examinable;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Key
extends Comparable<Key>,
Keyed,
Namespaced,
Examinable {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final char DEFAULT_SEPARATOR = ':';

    @NotNull
    public static Key key(@KeyPattern @NotNull String string) {
        return Key.key(string, ':');
    }

    @NotNull
    public static Key key(@NotNull String string, char c2) {
        Objects.requireNonNull(string, "string");
        int n2 = string.indexOf(c2);
        String string2 = n2 >= 1 ? string.substring(0, n2) : MINECRAFT_NAMESPACE;
        String string3 = n2 >= 0 ? string.substring(n2 + 1) : string;
        return Key.key(string2, string3);
    }

    @NotNull
    public static Key key(@NotNull Namespaced namespaced, @KeyPattern.Value @NotNull String string) {
        return Key.key(Objects.requireNonNull(namespaced, "namespaced").namespace(), string);
    }

    @NotNull
    public static Key key(@KeyPattern.Namespace @NotNull String string, @KeyPattern.Value @NotNull String string2) {
        return new KeyImpl(string, string2);
    }

    @NotNull
    public static Comparator<? super Key> comparator() {
        return KeyImpl.COMPARATOR;
    }

    public static boolean parseable(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(58);
        String string2 = n2 >= 1 ? string.substring(0, n2) : MINECRAFT_NAMESPACE;
        String string3 = n2 >= 0 ? string.substring(n2 + 1) : string;
        return Key.parseableNamespace(string2) && Key.parseableValue(string3);
    }

    public static boolean parseableNamespace(@NotNull String string) {
        return !Key.checkNamespace(string).isPresent();
    }

    @NotNull
    public static OptionalInt checkNamespace(@NotNull String string) {
        Objects.requireNonNull(string, "namespace");
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Key.allowedInNamespace(string.charAt(i2))) continue;
            return OptionalInt.of(i2);
        }
        return OptionalInt.empty();
    }

    public static boolean parseableValue(@NotNull String string) {
        return !Key.checkValue(string).isPresent();
    }

    @NotNull
    public static OptionalInt checkValue(@NotNull String string) {
        Objects.requireNonNull(string, "value");
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Key.allowedInValue(string.charAt(i2))) continue;
            return OptionalInt.of(i2);
        }
        return OptionalInt.empty();
    }

    public static boolean allowedInNamespace(char c2) {
        return KeyImpl.allowedInNamespace(c2);
    }

    public static boolean allowedInValue(char c2) {
        return KeyImpl.allowedInValue(c2);
    }

    @Override
    @KeyPattern.Namespace
    @NotNull
    public String namespace();

    @KeyPattern.Value
    @NotNull
    public String value();

    @NotNull
    public String asString();

    @NotNull
    default public String asMinimalString() {
        if (this.namespace().equals(MINECRAFT_NAMESPACE)) {
            return this.value();
        }
        return this.asString();
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace()), ExaminableProperty.of("value", this.value()));
    }

    @Override
    default public int compareTo(@NotNull Key key) {
        return Key.comparator().compare(this, key);
    }

    @Override
    @NotNull
    default public Key key() {
        return this;
    }
}

