/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.internal.properties;

import java.util.Objects;
import java.util.function.Function;
import me.ulrich.clans.library.kyori.adventure.internal.properties.AdventurePropertiesImpl;
import me.ulrich.clans.library.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AdventureProperties {
    public static final Property<Boolean> DEBUG = AdventureProperties.property("debug", Boolean::parseBoolean, false);
    public static final Property<String> DEFAULT_TRANSLATION_LOCALE = AdventureProperties.property("defaultTranslationLocale", Function.identity(), null);
    public static final Property<Boolean> SERVICE_LOAD_FAILURES_ARE_FATAL = AdventureProperties.property("serviceLoadFailuresAreFatal", Boolean::parseBoolean, Boolean.TRUE, false);
    public static final Property<Boolean> TEXT_WARN_WHEN_LEGACY_FORMATTING_DETECTED = AdventureProperties.property("text.warnWhenLegacyFormattingDetected", Boolean::parseBoolean, Boolean.FALSE);
    public static final Property<Integer> DEFAULT_FLATTENER_NESTING_LIMIT = AdventureProperties.property("defaultFlattenerNestingLimit", Integer::parseInt, -1);

    private AdventureProperties() {
    }

    @NotNull
    public static <T> Property<T> property(@NotNull String string, @NotNull Function<String, T> function, @Nullable T t2) {
        return AdventureProperties.property(string, function, t2, true);
    }

    @NotNull
    public static <T> Property<T> property(@NotNull String string, @NotNull Function<String, T> function, @Nullable T t2, boolean bl) {
        return AdventurePropertiesImpl.property(string, function, t2, bl);
    }

    @ApiStatus.Internal
    @ApiStatus.NonExtendable
    public static interface Property<T> {
        @Nullable
        public T value();

        @NotNull
        default public T valueOr(@NotNull T t2) {
            T t3 = this.value();
            return t3 == null ? Objects.requireNonNull(t2, "defaultValue") : t3;
        }
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface DefaultOverrideProvider {
        @Nullable
        public <T> T overrideDefault(@NotNull Property<T> var1, @Nullable T var2);
    }
}

