/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.audience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import me.ulrich.clans.library.kyori.adventure.audience.Audiences;
import me.ulrich.clans.library.kyori.adventure.audience.EmptyAudience;
import me.ulrich.clans.library.kyori.adventure.audience.ForwardingAudience;
import me.ulrich.clans.library.kyori.adventure.audience.ForwardingAudienceOverrideNotRequired;
import me.ulrich.clans.library.kyori.adventure.audience.MessageType;
import me.ulrich.clans.library.kyori.adventure.bossbar.BossBar;
import me.ulrich.clans.library.kyori.adventure.chat.SignedMessage;
import me.ulrich.clans.library.kyori.adventure.dialog.DialogLike;
import me.ulrich.clans.library.kyori.adventure.identity.Identified;
import me.ulrich.clans.library.kyori.adventure.identity.Identity;
import me.ulrich.clans.library.kyori.adventure.inventory.Book;
import me.ulrich.clans.library.kyori.adventure.pointer.Pointered;
import me.ulrich.clans.library.kyori.adventure.resource.ResourcePackInfo;
import me.ulrich.clans.library.kyori.adventure.resource.ResourcePackInfoLike;
import me.ulrich.clans.library.kyori.adventure.resource.ResourcePackRequest;
import me.ulrich.clans.library.kyori.adventure.resource.ResourcePackRequestLike;
import me.ulrich.clans.library.kyori.adventure.sound.Sound;
import me.ulrich.clans.library.kyori.adventure.sound.SoundStop;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.title.Title;
import me.ulrich.clans.library.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Audience
extends Pointered {
    @NotNull
    public static Audience empty() {
        return EmptyAudience.INSTANCE;
    }

    @NotNull
    public static Audience audience(Audience ... audienceArray) {
        int n2 = audienceArray.length;
        if (n2 == 0) {
            return Audience.empty();
        }
        if (n2 == 1) {
            return audienceArray[0];
        }
        return Audience.audience(Arrays.asList(audienceArray));
    }

    @NotNull
    public static ForwardingAudience audience(@NotNull Iterable<? extends Audience> iterable) {
        return () -> iterable;
    }

    @NotNull
    public static Collector<? super Audience, ?, ForwardingAudience> toAudience() {
        return Audiences.COLLECTOR;
    }

    @NotNull
    default public Audience filterAudience(@NotNull Predicate<? super Audience> predicate) {
        return predicate.test(this) ? this : Audience.empty();
    }

    default public void forEachAudience(@NotNull Consumer<? super Audience> consumer) {
        consumer.accept(this);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull ComponentLike componentLike) {
        this.sendMessage(componentLike.asComponent());
    }

    default public void sendMessage(@NotNull Component component) {
        this.sendMessage(component, MessageType.SYSTEM);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull ComponentLike componentLike, @NotNull MessageType messageType) {
        this.sendMessage(componentLike.asComponent(), messageType);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Component component, @NotNull MessageType messageType) {
        this.sendMessage(Identity.nil(), component, messageType);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identified identified, @NotNull ComponentLike componentLike) {
        this.sendMessage(identified, componentLike.asComponent());
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identity identity, @NotNull ComponentLike componentLike) {
        this.sendMessage(identity, componentLike.asComponent());
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identified identified, @NotNull Component component) {
        this.sendMessage(identified, component, MessageType.CHAT);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identity identity, @NotNull Component component) {
        this.sendMessage(identity, component, MessageType.CHAT);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identified identified, @NotNull ComponentLike componentLike, @NotNull MessageType messageType) {
        this.sendMessage(identified, componentLike.asComponent(), messageType);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identity identity, @NotNull ComponentLike componentLike, @NotNull MessageType messageType) {
        this.sendMessage(identity, componentLike.asComponent(), messageType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identified identified, @NotNull Component component, @NotNull MessageType messageType) {
        this.sendMessage(identified.identity(), component, messageType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identity identity, @NotNull Component component, @NotNull MessageType messageType) {
    }

    default public void sendMessage(@NotNull Component component,  @NotNull ChatType.Bound bound) {
        this.sendMessage(component, MessageType.CHAT);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull ComponentLike componentLike,  @NotNull ChatType.Bound bound) {
        this.sendMessage(componentLike.asComponent(), bound);
    }

    default public void sendMessage(@NotNull SignedMessage signedMessage,  @NotNull ChatType.Bound bound) {
        Component component;
        Component component2 = component = signedMessage.unsignedContent() != null ? signedMessage.unsignedContent() : Component.text(signedMessage.message());
        if (signedMessage.isSystem()) {
            this.sendMessage(component);
        } else {
            this.sendMessage(signedMessage.identity(), component, MessageType.CHAT);
        }
    }

    @ForwardingAudienceOverrideNotRequired
    default public void deleteMessage(@NotNull SignedMessage signedMessage) {
        if (signedMessage.canDelete()) {
            this.deleteMessage(Objects.requireNonNull(signedMessage.signature()));
        }
    }

    default public void deleteMessage(@NotNull SignedMessage.Signature signature) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendActionBar(@NotNull ComponentLike componentLike) {
        this.sendActionBar(componentLike.asComponent());
    }

    default public void sendActionBar(@NotNull Component component) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendPlayerListHeader(@NotNull ComponentLike componentLike) {
        this.sendPlayerListHeader(componentLike.asComponent());
    }

    default public void sendPlayerListHeader(@NotNull Component component) {
        this.sendPlayerListHeaderAndFooter(component, Component.empty());
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendPlayerListFooter(@NotNull ComponentLike componentLike) {
        this.sendPlayerListFooter(componentLike.asComponent());
    }

    default public void sendPlayerListFooter(@NotNull Component component) {
        this.sendPlayerListHeaderAndFooter(Component.empty(), component);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendPlayerListHeaderAndFooter(@NotNull ComponentLike componentLike, @NotNull ComponentLike componentLike2) {
        this.sendPlayerListHeaderAndFooter(componentLike.asComponent(), componentLike2.asComponent());
    }

    default public void sendPlayerListHeaderAndFooter(@NotNull Component component, @NotNull Component component2) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void showTitle(@NotNull Title title) {
        Title.Times times = title.times();
        if (times != null) {
            this.sendTitlePart(TitlePart.TIMES, times);
        }
        this.sendTitlePart(TitlePart.SUBTITLE, title.subtitle());
        this.sendTitlePart(TitlePart.TITLE, title.title());
    }

    default public <T> void sendTitlePart(@NotNull TitlePart<T> titlePart, @NotNull T t2) {
    }

    default public void clearTitle() {
    }

    default public void resetTitle() {
    }

    default public void showBossBar(@NotNull BossBar bossBar) {
    }

    default public void hideBossBar(@NotNull BossBar bossBar) {
    }

    default public void playSound(@NotNull Sound sound) {
    }

    default public void playSound(@NotNull Sound sound, double d2, double d3, double d4) {
    }

    default public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void stopSound(@NotNull Sound sound) {
        this.stopSound(Objects.requireNonNull(sound, "sound").asStop());
    }

    default public void stopSound(@NotNull SoundStop soundStop) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void openBook(@NotNull Book.Builder builder) {
        this.openBook(builder.build());
    }

    default public void openBook(@NotNull Book book) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendResourcePacks(@NotNull ResourcePackInfoLike resourcePackInfoLike, ResourcePackInfoLike ... resourcePackInfoLikeArray) {
        this.sendResourcePacks(ResourcePackRequest.addingRequest(resourcePackInfoLike, resourcePackInfoLikeArray));
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendResourcePacks(@NotNull ResourcePackRequestLike resourcePackRequestLike) {
        this.sendResourcePacks(resourcePackRequestLike.asResourcePackRequest());
    }

    default public void sendResourcePacks(@NotNull ResourcePackRequest resourcePackRequest) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void removeResourcePacks(@NotNull ResourcePackRequestLike resourcePackRequestLike) {
        this.removeResourcePacks(resourcePackRequestLike.asResourcePackRequest());
    }

    @ForwardingAudienceOverrideNotRequired
    default public void removeResourcePacks(@NotNull ResourcePackRequest resourcePackRequest) {
        List<ResourcePackInfo> list = resourcePackRequest.packs();
        if (list.size() == 1) {
            this.removeResourcePacks(list.get(0).id(), new UUID[0]);
        } else if (list.isEmpty()) {
            return;
        }
        UUID[] uUIDArray = new UUID[list.size() - 1];
        for (int i2 = 0; i2 < uUIDArray.length; ++i2) {
            uUIDArray[i2] = list.get(i2 + 1).id();
        }
        this.removeResourcePacks(list.get(0).id(), uUIDArray);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void removeResourcePacks(@NotNull ResourcePackInfoLike resourcePackInfoLike, ResourcePackInfoLike ... resourcePackInfoLikeArray) {
        UUID[] uUIDArray = new UUID[resourcePackInfoLikeArray.length];
        for (int i2 = 0; i2 < resourcePackInfoLikeArray.length; ++i2) {
            uUIDArray[i2] = resourcePackInfoLikeArray[i2].asResourcePackInfo().id();
        }
        this.removeResourcePacks(resourcePackInfoLike.asResourcePackInfo().id(), uUIDArray);
    }

    default public void removeResourcePacks(@NotNull Iterable<UUID> iterable) {
        UUID[] uUIDArray;
        Iterator<UUID> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        UUID uUID = iterator.next();
        if (!iterator.hasNext()) {
            uUIDArray = new UUID[]{};
        } else if (iterable instanceof Collection) {
            uUIDArray = new UUID[((Collection)iterable).size() - 1];
            for (int i2 = 0; i2 < uUIDArray.length; ++i2) {
                uUIDArray[i2] = iterator.next();
            }
        } else {
            ArrayList<UUID> arrayList = new ArrayList<UUID>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            uUIDArray = arrayList.toArray(new UUID[0]);
        }
        this.removeResourcePacks(uUID, uUIDArray);
    }

    default public void removeResourcePacks(@NotNull UUID uUID, UUID ... uUIDArray) {
    }

    default public void clearResourcePacks() {
    }

    default public void showDialog(@NotNull DialogLike dialogLike) {
    }

    default public void closeDialog() {
    }
}

