/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.guis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.ulrich.clans.library.gui.components.GuiContainer;
import me.ulrich.clans.library.gui.components.InteractionModifier;
import me.ulrich.clans.library.gui.components.ScrollType;
import me.ulrich.clans.library.gui.guis.GuiItem;
import me.ulrich.clans.library.gui.guis.PaginatedGui;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;

public class ScrollingGui
extends PaginatedGui {
    private final ScrollType scrollType;
    private int scrollSize = 0;

    public ScrollingGui(@NotNull GuiContainer guiContainer, int n2, @NotNull ScrollType scrollType, @NotNull Set<InteractionModifier> set) {
        super(guiContainer, n2, set);
        this.scrollType = scrollType;
    }

    @Override
    public boolean next() {
        if (this.getPageNum() * this.scrollSize + this.getPageSize() >= this.getPageItems().size() + this.scrollSize) {
            return false;
        }
        this.setPageNum(this.getPageNum() + 1);
        this.updatePage();
        return true;
    }

    @Override
    public boolean previous() {
        if (this.getPageNum() - 1 == 0) {
            return false;
        }
        this.setPageNum(this.getPageNum() - 1);
        this.updatePage();
        return true;
    }

    @Override
    public void open(@NotNull HumanEntity humanEntity) {
        this.open(humanEntity, 1);
    }

    @Override
    public void open(@NotNull HumanEntity humanEntity, int n2) {
        if (humanEntity.isSleeping()) {
            return;
        }
        this.getInventory().clear();
        this.getMutableCurrentPageItems().clear();
        this.populateGui();
        if (this.getPageSize() == 0) {
            this.setPageSize(this.calculatePageSize());
        }
        if (this.scrollSize == 0) {
            this.scrollSize = this.calculateScrollSize();
        }
        if (n2 > 0 && n2 * this.scrollSize + this.getPageSize() <= this.getPageItems().size() + this.scrollSize) {
            this.setPageNum(n2);
        }
        this.populatePage();
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    void updatePage() {
        this.clearPage();
        this.populatePage();
    }

    private void populatePage() {
        for (GuiItem guiItem : this.getPage(this.getPageNum())) {
            if (this.scrollType == ScrollType.HORIZONTAL) {
                this.putItemHorizontally(guiItem);
                continue;
            }
            this.putItemVertically(guiItem);
        }
    }

    private int calculateScrollSize() {
        int n2 = 0;
        if (this.scrollType == ScrollType.VERTICAL) {
            boolean bl = false;
            for (int i2 = 1; i2 <= this.getRows(); ++i2) {
                for (int i3 = 1; i3 <= 9; ++i3) {
                    int n3 = this.getSlotFromRowCol(i2, i3);
                    if (this.getInventory().getItem(n3) != null) continue;
                    if (!bl) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) continue;
                return n2;
            }
            return n2;
        }
        boolean bl = false;
        for (int i4 = 1; i4 <= 9; ++i4) {
            for (int i5 = 1; i5 <= this.getRows(); ++i5) {
                int n4 = this.getSlotFromRowCol(i5, i4);
                if (this.getInventory().getItem(n4) != null) continue;
                if (!bl) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) continue;
            return n2;
        }
        return n2;
    }

    private void putItemVertically(GuiItem guiItem) {
        for (int i2 = 0; i2 < this.getRows() * 9; ++i2) {
            if (this.getGuiItem(i2) != null || this.getInventory().getItem(i2) != null) continue;
            this.getMutableCurrentPageItems().put(i2, guiItem);
            this.getInventory().setItem(i2, guiItem.getItemStack());
            break;
        }
    }

    private void putItemHorizontally(GuiItem guiItem) {
        for (int i2 = 1; i2 < 10; ++i2) {
            for (int i3 = 1; i3 <= this.getRows(); ++i3) {
                int n2 = this.getSlotFromRowCol(i3, i2);
                if (this.getGuiItem(n2) != null || this.getInventory().getItem(n2) != null) continue;
                this.getMutableCurrentPageItems().put(n2, guiItem);
                this.getInventory().setItem(n2, guiItem.getItemStack());
                return;
            }
        }
    }

    private List<GuiItem> getPage(int n2) {
        int n3 = n2 - 1;
        int n4 = this.getPageItems().size();
        ArrayList<GuiItem> arrayList = new ArrayList<GuiItem>();
        int n5 = n3 * this.scrollSize + this.getPageSize();
        if (n5 > n4) {
            n5 = n4;
        }
        for (int i2 = n3 * this.scrollSize; i2 < n5; ++i2) {
            arrayList.add(this.getPageItems().get(i2));
        }
        return arrayList;
    }
}

