/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.guis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.ulrich.clans.library.gui.components.GuiContainer;
import me.ulrich.clans.library.gui.components.InteractionModifier;
import me.ulrich.clans.library.gui.guis.BaseGui;
import me.ulrich.clans.library.gui.guis.GuiItem;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PaginatedGui
extends BaseGui {
    private final List<GuiItem> pageItems = new ArrayList<GuiItem>();
    private final Map<Integer, GuiItem> currentPage;
    private int pageSize;
    private int pageNum = 1;

    public PaginatedGui(@NotNull GuiContainer guiContainer, int n2, @NotNull Set<InteractionModifier> set) {
        super(guiContainer, set);
        this.pageSize = n2;
        this.currentPage = new LinkedHashMap<Integer, GuiItem>(guiContainer.inventorySize());
    }

    public BaseGui setPageSize(int n2) {
        this.pageSize = n2;
        return this;
    }

    public void addItem(@NotNull GuiItem guiItem) {
        this.pageItems.add(guiItem);
    }

    @Override
    public void addItem(GuiItem ... guiItemArray) {
        this.pageItems.addAll(Arrays.asList(guiItemArray));
    }

    @Override
    public void update() {
        this.getInventory().clear();
        this.populateGui();
        this.updatePage();
    }

    public void updatePageItem(int n2, @NotNull ItemStack itemStack) {
        if (!this.currentPage.containsKey(n2)) {
            return;
        }
        GuiItem guiItem = this.currentPage.get(n2);
        guiItem.setItemStack(itemStack);
        this.getInventory().setItem(n2, guiItem.getItemStack());
    }

    public void updatePageItem(int n2, int n3, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(n2, n3), itemStack);
    }

    public void updatePageItem(int n2, @NotNull GuiItem guiItem) {
        if (!this.currentPage.containsKey(n2)) {
            return;
        }
        GuiItem guiItem2 = this.currentPage.get(n2);
        int n3 = this.pageItems.indexOf(this.currentPage.get(n2));
        this.currentPage.put(n2, guiItem);
        this.pageItems.set(n3, guiItem);
        this.getInventory().setItem(n2, guiItem.getItemStack());
    }

    public void updatePageItem(int n2, int n3, @NotNull GuiItem guiItem) {
        this.updateItem(this.getSlotFromRowCol(n2, n3), guiItem);
    }

    public void removePageItem(@NotNull GuiItem guiItem) {
        this.pageItems.remove(guiItem);
        this.updatePage();
    }

    public void removePageItem(@NotNull ItemStack itemStack) {
        Optional<GuiItem> optional = this.pageItems.stream().filter(guiItem -> guiItem.getItemStack().equals((Object)itemStack)).findFirst();
        optional.ifPresent(this::removePageItem);
    }

    @Override
    public void open(@NotNull HumanEntity humanEntity) {
        this.open(humanEntity, 1);
    }

    public void open(@NotNull HumanEntity humanEntity, int n2) {
        if (humanEntity.isSleeping()) {
            return;
        }
        if (n2 <= this.getPagesNum() || n2 > 0) {
            this.pageNum = n2;
        }
        this.getInventory().clear();
        this.currentPage.clear();
        this.populateGui();
        if (this.pageSize == 0) {
            this.pageSize = this.calculatePageSize();
        }
        this.populatePage();
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    public BaseGui updateTitle(@NotNull Component component) {
        this.setUpdating(true);
        ArrayList arrayList = new ArrayList(this.getInventory().getViewers());
        GuiContainer guiContainer = this.guiContainer();
        guiContainer.title(component);
        this.setInventory(guiContainer.createInventory(this));
        for (HumanEntity humanEntity : arrayList) {
            this.open(humanEntity, this.getPageNum());
        }
        this.setUpdating(false);
        return this;
    }

    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull GuiItem> getCurrentPageItems() {
        return Collections.unmodifiableMap(this.currentPage);
    }

    @NotNull
    public @NotNull List<@NotNull GuiItem> getPageItems() {
        return Collections.unmodifiableList(this.pageItems);
    }

    public int getCurrentPageNum() {
        return this.pageNum;
    }

    public int getNextPageNum() {
        if (this.pageNum + 1 > this.getPagesNum()) {
            return this.pageNum;
        }
        return this.pageNum + 1;
    }

    public int getPrevPageNum() {
        if (this.pageNum - 1 == 0) {
            return this.pageNum;
        }
        return this.pageNum - 1;
    }

    public boolean next() {
        if (this.pageNum + 1 > this.getPagesNum()) {
            return false;
        }
        ++this.pageNum;
        this.updatePage();
        return true;
    }

    public boolean previous() {
        if (this.pageNum - 1 == 0) {
            return false;
        }
        --this.pageNum;
        this.updatePage();
        return true;
    }

    GuiItem getPageItem(int n2) {
        return this.currentPage.get(n2);
    }

    private List<GuiItem> getPageNum(int n2) {
        int n3 = n2 - 1;
        ArrayList<GuiItem> arrayList = new ArrayList<GuiItem>();
        int n4 = n3 * this.pageSize + this.pageSize;
        if (n4 > this.pageItems.size()) {
            n4 = this.pageItems.size();
        }
        for (int i2 = n3 * this.pageSize; i2 < n4; ++i2) {
            arrayList.add(this.pageItems.get(i2));
        }
        return arrayList;
    }

    public int getPagesNum() {
        if (this.pageSize == 0) {
            this.pageSize = this.calculatePageSize();
        }
        return (int)Math.ceil((double)this.pageItems.size() / (double)this.pageSize);
    }

    private void populatePage() {
        int n2 = 0;
        int n3 = this.getInventory().getSize();
        Iterator<GuiItem> iterator = this.getPageNum(this.pageNum).iterator();
        while (iterator.hasNext() && n2 < n3) {
            if (this.getGuiItem(n2) != null || this.getInventory().getItem(n2) != null) {
                ++n2;
                continue;
            }
            GuiItem guiItem = iterator.next();
            this.currentPage.put(n2, guiItem);
            this.getInventory().setItem(n2, guiItem.getItemStack());
            ++n2;
        }
    }

    Map<Integer, GuiItem> getMutableCurrentPageItems() {
        return this.currentPage;
    }

    void clearPage() {
        for (Map.Entry<Integer, GuiItem> entry : this.currentPage.entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), null);
        }
    }

    public void clearPageItems(boolean bl) {
        this.pageItems.clear();
        if (bl) {
            this.update();
        }
    }

    public void clearPageItems() {
        this.clearPageItems(false);
    }

    int getPageSize() {
        return this.pageSize;
    }

    int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int n2) {
        this.pageNum = n2;
    }

    void updatePage() {
        this.clearPage();
        this.populatePage();
    }

    int calculatePageSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getRows() * 9; ++i2) {
            if (this.getGuiItem(i2) != null) continue;
            ++n2;
        }
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }
}

