/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.guis;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.gui.TriumphGui;
import me.ulrich.clans.library.gui.components.GuiAction;
import me.ulrich.clans.library.gui.components.GuiContainer;
import me.ulrich.clans.library.gui.components.GuiType;
import me.ulrich.clans.library.gui.components.InteractionModifier;
import me.ulrich.clans.library.gui.components.exception.GuiException;
import me.ulrich.clans.library.gui.components.util.GuiFiller;
import me.ulrich.clans.library.gui.components.util.VersionHelper;
import me.ulrich.clans.library.gui.guis.GuiItem;
import me.ulrich.clans.library.gui.guis.GuiListener;
import me.ulrich.clans.library.gui.guis.InteractionModifierListener;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGui
implements InventoryHolder {
    private static final Plugin plugin = TriumphGui.getPlugin();
    private static Method GET_SCHEDULER_METHOD = null;
    private static Method EXECUTE_METHOD = null;
    private final GuiFiller filler = new GuiFiller(this);
    private final Map<Integer, GuiItem> guiItems;
    private final Map<Integer, GuiAction<InventoryClickEvent>> slotActions;
    private final Set<InteractionModifier> interactionModifiers;
    private final GuiContainer guiContainer;
    private Inventory inventory;
    private GuiAction<InventoryClickEvent> defaultClickAction;
    private GuiAction<InventoryClickEvent> defaultTopClickAction;
    private GuiAction<InventoryClickEvent> playerInventoryAction;
    private GuiAction<InventoryDragEvent> dragAction;
    private GuiAction<InventoryCloseEvent> closeGuiAction;
    private GuiAction<InventoryOpenEvent> openGuiAction;
    private GuiAction<InventoryClickEvent> outsideClickAction;
    private boolean updating;
    private boolean runCloseAction = true;
    private boolean runOpenAction = true;

    public BaseGui(@NotNull GuiContainer guiContainer, @NotNull Set<InteractionModifier> set) {
        this.interactionModifiers = this.safeCopyOf(set);
        this.guiContainer = guiContainer;
        this.inventory = guiContainer.createInventory(this);
        this.slotActions = new LinkedHashMap<Integer, GuiAction<InventoryClickEvent>>(guiContainer.inventorySize());
        this.guiItems = new LinkedHashMap<Integer, GuiItem>(guiContainer.inventorySize());
    }

    @NotNull
    private Set<InteractionModifier> safeCopyOf(@NotNull Set<InteractionModifier> set) {
        if (set.isEmpty()) {
            return EnumSet.noneOf(InteractionModifier.class);
        }
        return EnumSet.copyOf(set);
    }

    @NotNull
    public Component title() {
        return this.guiContainer.title();
    }

    public void setItem(int n2, @NotNull GuiItem guiItem) {
        this.validateSlot(n2);
        this.guiItems.put(n2, guiItem);
    }

    public void removeItem(@NotNull GuiItem guiItem) {
        this.guiItems.entrySet().stream().filter(entry -> ((GuiItem)entry.getValue()).equals(guiItem)).findFirst().ifPresent(entry -> {
            this.guiItems.remove(entry.getKey());
            this.inventory.remove(((GuiItem)entry.getValue()).getItemStack());
        });
    }

    public void removeItem(@NotNull ItemStack itemStack) {
        this.guiItems.entrySet().stream().filter(entry -> ((GuiItem)entry.getValue()).getItemStack().equals((Object)itemStack)).findFirst().ifPresent(entry -> {
            this.guiItems.remove(entry.getKey());
            this.inventory.remove(itemStack);
        });
    }

    public void removeItem(int n2) {
        this.validateSlot(n2);
        this.guiItems.remove(n2);
        this.inventory.setItem(n2, null);
    }

    public void removeItem(int n2, int n3) {
        this.removeItem(this.getSlotFromRowCol(n2, n3));
    }

    public void setItem(@NotNull List<Integer> list, @NotNull GuiItem guiItem) {
        for (int n2 : list) {
            this.setItem(n2, guiItem);
        }
    }

    public void setItem(int n2, int n3, @NotNull GuiItem guiItem) {
        this.setItem(this.getSlotFromRowCol(n2, n3), guiItem);
    }

    public void addItem(GuiItem ... guiItemArray) {
        this.addItem(false, guiItemArray);
    }

    public void addItem(boolean bl, GuiItem ... guiItemArray) {
        ArrayList<GuiItem> arrayList = new ArrayList<GuiItem>();
        int n2 = this.guiContainer.rows();
        GuiType guiType = this.guiContainer.guiType();
        block0: for (GuiItem guiItem : guiItemArray) {
            for (int i2 = 0; i2 < n2 * 9; ++i2) {
                if (this.guiItems.get(i2) != null) {
                    if (i2 != n2 * 9 - 1) continue;
                    arrayList.add(guiItem);
                    continue;
                }
                this.guiItems.put(i2, guiItem);
                continue block0;
            }
        }
        if (!bl || n2 >= 6 || arrayList.isEmpty() || guiType != GuiType.CHEST) {
            return;
        }
        if (!(this.guiContainer instanceof GuiContainer.Chest)) {
            return;
        }
        ((GuiContainer.Chest)this.guiContainer).rows(this.guiContainer.rows() + 1);
        this.inventory = this.guiContainer.createInventory(this);
        this.update();
        this.addItem(true, arrayList.toArray(new GuiItem[0]));
    }

    public void addSlotAction(int n2, @Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.validateSlot(n2);
        this.slotActions.put(n2, guiAction);
    }

    public void addSlotAction(int n2, int n3, @Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.addSlotAction(this.getSlotFromRowCol(n2, n3), guiAction);
    }

    @Nullable
    public GuiItem getGuiItem(int n2) {
        return this.guiItems.get(n2);
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean bl) {
        this.updating = bl;
    }

    public void open(@NotNull HumanEntity humanEntity) {
        if (humanEntity.isSleeping()) {
            return;
        }
        this.inventory.clear();
        this.populateGui();
        humanEntity.openInventory(this.inventory);
    }

    public void close(@NotNull HumanEntity humanEntity) {
        this.close(humanEntity, true);
    }

    public void close(@NotNull HumanEntity humanEntity, boolean bl) {
        Runnable runnable = () -> {
            this.runCloseAction = bl;
            humanEntity.closeInventory();
            this.runCloseAction = true;
        };
        if (VersionHelper.IS_FOLIA) {
            if (GET_SCHEDULER_METHOD == null || EXECUTE_METHOD == null) {
                throw new GuiException("Could not find Folia Scheduler methods.");
            }
            try {
                EXECUTE_METHOD.invoke(GET_SCHEDULER_METHOD.invoke((Object)humanEntity, new Object[0]), plugin, runnable, null, 2L);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new GuiException("Could not invoke Folia task.", reflectiveOperationException);
            }
            return;
        }
        Bukkit.getScheduler().runTaskLater(plugin, runnable, 2L);
    }

    public void update() {
        this.inventory.clear();
        this.populateGui();
    }

    @NotNull
    @Contract(value="_ -> this")
    public BaseGui updateTitle(@NotNull Component component) {
        this.updating = true;
        ArrayList arrayList = new ArrayList(this.inventory.getViewers());
        this.guiContainer.title(component);
        this.inventory = this.guiContainer.createInventory(this);
        for (HumanEntity humanEntity : arrayList) {
            this.open(humanEntity);
        }
        this.updating = false;
        return this;
    }

    public void updateItem(int n2, @NotNull ItemStack itemStack) {
        GuiItem guiItem = this.guiItems.get(n2);
        if (guiItem == null) {
            this.updateItem(n2, new GuiItem(itemStack));
            return;
        }
        guiItem.setItemStack(itemStack);
        this.updateItem(n2, guiItem);
    }

    public void updateItem(int n2, int n3, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(n2, n3), itemStack);
    }

    public void updateItem(int n2, @NotNull GuiItem guiItem) {
        this.guiItems.put(n2, guiItem);
        this.inventory.setItem(n2, guiItem.getItemStack());
    }

    public void updateItem(int n2, int n3, @NotNull GuiItem guiItem) {
        this.updateItem(this.getSlotFromRowCol(n2, n3), guiItem);
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui disableItemPlace() {
        this.interactionModifiers.add(InteractionModifier.PREVENT_ITEM_PLACE);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui disableItemTake() {
        this.interactionModifiers.add(InteractionModifier.PREVENT_ITEM_TAKE);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui disableItemSwap() {
        this.interactionModifiers.add(InteractionModifier.PREVENT_ITEM_SWAP);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui disableItemDrop() {
        this.interactionModifiers.add(InteractionModifier.PREVENT_ITEM_DROP);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui disableOtherActions() {
        this.interactionModifiers.add(InteractionModifier.PREVENT_OTHER_ACTIONS);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui disableAllInteractions() {
        this.interactionModifiers.addAll(InteractionModifier.VALUES);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui enableItemPlace() {
        this.interactionModifiers.remove((Object)InteractionModifier.PREVENT_ITEM_PLACE);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui enableItemTake() {
        this.interactionModifiers.remove((Object)InteractionModifier.PREVENT_ITEM_TAKE);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui enableItemSwap() {
        this.interactionModifiers.remove((Object)InteractionModifier.PREVENT_ITEM_SWAP);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui enableItemDrop() {
        this.interactionModifiers.remove((Object)InteractionModifier.PREVENT_ITEM_DROP);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui enableOtherActions() {
        this.interactionModifiers.remove((Object)InteractionModifier.PREVENT_OTHER_ACTIONS);
        return this;
    }

    @NotNull
    @Contract(value=" -> this")
    public BaseGui enableAllInteractions() {
        this.interactionModifiers.clear();
        return this;
    }

    public boolean allInteractionsDisabled() {
        return this.interactionModifiers.size() == InteractionModifier.VALUES.size();
    }

    public boolean canPlaceItems() {
        return !this.interactionModifiers.contains((Object)InteractionModifier.PREVENT_ITEM_PLACE);
    }

    public boolean canTakeItems() {
        return !this.interactionModifiers.contains((Object)InteractionModifier.PREVENT_ITEM_TAKE);
    }

    public boolean canSwapItems() {
        return !this.interactionModifiers.contains((Object)InteractionModifier.PREVENT_ITEM_SWAP);
    }

    public boolean canDropItems() {
        return !this.interactionModifiers.contains((Object)InteractionModifier.PREVENT_ITEM_DROP);
    }

    public boolean allowsOtherActions() {
        return !this.interactionModifiers.contains((Object)InteractionModifier.PREVENT_OTHER_ACTIONS);
    }

    @NotNull
    public GuiFiller getFiller() {
        return this.filler;
    }

    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull GuiItem> getGuiItems() {
        return Collections.unmodifiableMap(this.guiItems);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(@NotNull Inventory inventory) {
        this.inventory = inventory;
    }

    public int getRows() {
        return this.guiContainer.rows();
    }

    @NotNull
    public GuiType guiType() {
        return this.guiContainer.guiType();
    }

    @Nullable
    GuiAction<InventoryClickEvent> getDefaultClickAction() {
        return this.defaultClickAction;
    }

    public void setDefaultClickAction(@Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.defaultClickAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getDefaultTopClickAction() {
        return this.defaultTopClickAction;
    }

    public void setDefaultTopClickAction(@Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.defaultTopClickAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getPlayerInventoryAction() {
        return this.playerInventoryAction;
    }

    public void setPlayerInventoryAction(@Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.playerInventoryAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryDragEvent> getDragAction() {
        return this.dragAction;
    }

    public void setDragAction(@Nullable GuiAction<@NotNull InventoryDragEvent> guiAction) {
        this.dragAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryCloseEvent> getCloseGuiAction() {
        return this.closeGuiAction;
    }

    public void setCloseGuiAction(@Nullable GuiAction<@NotNull InventoryCloseEvent> guiAction) {
        this.closeGuiAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryOpenEvent> getOpenGuiAction() {
        return this.openGuiAction;
    }

    public void setOpenGuiAction(@Nullable GuiAction<@NotNull InventoryOpenEvent> guiAction) {
        this.openGuiAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getOutsideClickAction() {
        return this.outsideClickAction;
    }

    public void setOutsideClickAction(@Nullable GuiAction<@NotNull InventoryClickEvent> guiAction) {
        this.outsideClickAction = guiAction;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getSlotAction(int n2) {
        return this.slotActions.get(n2);
    }

    void populateGui() {
        for (Map.Entry<Integer, GuiItem> entry : this.guiItems.entrySet()) {
            this.inventory.setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
        }
    }

    boolean shouldRunCloseAction() {
        return this.runCloseAction;
    }

    boolean shouldRunOpenAction() {
        return this.runOpenAction;
    }

    int getSlotFromRowCol(int n2, int n3) {
        return n3 + (n2 - 1) * 9 - 1;
    }

    private void validateSlot(int n2) {
        GuiType guiType = this.guiContainer.guiType();
        int n3 = guiType.getLimit();
        if (guiType == GuiType.CHEST) {
            if (n2 < 0 || n2 >= this.guiContainer.rows() * n3) {
                this.throwInvalidSlot(n2);
            }
            return;
        }
        if (n2 < 0 || n2 > n3) {
            this.throwInvalidSlot(n2);
        }
    }

    private void throwInvalidSlot(int n2) {
        if (this.guiContainer.guiType() == GuiType.CHEST) {
            throw new GuiException("Slot " + n2 + " is not valid for the gui type - " + this.guiContainer.guiType().name() + " and rows - " + this.guiContainer.rows() + "!");
        }
        throw new GuiException("Slot " + n2 + " is not valid for the gui type - " + this.guiContainer.guiType().name() + "!");
    }

    @NotNull
    protected GuiContainer guiContainer() {
        return this.guiContainer;
    }

    static {
        try {
            GET_SCHEDULER_METHOD = Entity.class.getMethod("getScheduler", new Class[0]);
            Class<?> clazz = Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            EXECUTE_METHOD = clazz.getMethod("execute", Plugin.class, Runnable.class, Runnable.class, Long.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(), plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new InteractionModifierListener(), plugin);
    }
}

