/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.components.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.ulrich.clans.library.gui.components.GuiType;
import me.ulrich.clans.library.gui.components.exception.GuiException;
import me.ulrich.clans.library.gui.guis.BaseGui;
import me.ulrich.clans.library.gui.guis.GuiItem;
import me.ulrich.clans.library.gui.guis.PaginatedGui;
import org.jetbrains.annotations.NotNull;

public final class GuiFiller {
    private final BaseGui gui;

    public GuiFiller(BaseGui baseGui) {
        this.gui = baseGui;
    }

    public void fillTop(@NotNull GuiItem guiItem) {
        this.fillTop(Collections.singletonList(guiItem));
    }

    public void fillTop(@NotNull List<GuiItem> list) {
        List<GuiItem> list2 = this.repeatList(list);
        for (int i2 = 0; i2 < 9; ++i2) {
            if (this.gui.getGuiItems().containsKey(i2)) continue;
            this.gui.setItem(i2, list2.get(i2));
        }
    }

    public void fillBottom(@NotNull GuiItem guiItem) {
        this.fillBottom(Collections.singletonList(guiItem));
    }

    public void fillBottom(@NotNull List<GuiItem> list) {
        int n2 = this.gui.getRows();
        List<GuiItem> list2 = this.repeatList(list);
        for (int i2 = 9; i2 > 0; --i2) {
            if (this.gui.getGuiItems().get(n2 * 9 - i2) != null) continue;
            this.gui.setItem(n2 * 9 - i2, list2.get(i2));
        }
    }

    public void fillBorder(@NotNull GuiItem guiItem) {
        this.fillBorder(Collections.singletonList(guiItem));
    }

    public void fillBorder(@NotNull List<GuiItem> list) {
        int n2 = this.gui.getRows();
        if (n2 <= 2) {
            return;
        }
        List<GuiItem> list2 = this.repeatList(list);
        for (int i2 = 0; i2 < n2 * 9; ++i2) {
            if (i2 > 8 && (i2 < n2 * 9 - 8 || i2 > n2 * 9 - 2) && i2 % 9 != 0 && i2 % 9 != 8) continue;
            this.gui.setItem(i2, list2.get(i2));
        }
    }

    public void fillBetweenPoints(int n2, int n3, int n4, int n5, @NotNull GuiItem guiItem) {
        this.fillBetweenPoints(n2, n3, n4, n5, Collections.singletonList(guiItem));
    }

    public void fillBetweenPoints(int n2, int n3, int n4, int n5, @NotNull List<GuiItem> list) {
        int n6 = Math.min(n2, n4);
        int n7 = Math.max(n2, n4);
        int n8 = Math.min(n3, n5);
        int n9 = Math.max(n3, n5);
        int n10 = this.gui.getRows();
        List<GuiItem> list2 = this.repeatList(list);
        for (int i2 = 1; i2 <= n10; ++i2) {
            for (int i3 = 1; i3 <= 9; ++i3) {
                int n11 = this.getSlotFromRowCol(i2, i3);
                if (i2 < n6 || i2 > n7 || i3 < n8 || i3 > n9) continue;
                this.gui.setItem(n11, list2.get(n11));
            }
        }
    }

    public void fill(@NotNull GuiItem guiItem) {
        this.fill(Collections.singletonList(guiItem));
    }

    public void fill(@NotNull List<GuiItem> list) {
        if (this.gui instanceof PaginatedGui) {
            throw new GuiException("Full filling a GUI is not supported in a Paginated GUI!");
        }
        GuiType guiType = this.gui.guiType();
        int n2 = guiType == GuiType.CHEST ? this.gui.getRows() * guiType.getLimit() : guiType.getFillSize();
        List<GuiItem> list2 = this.repeatList(list);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.gui.getGuiItems().get(i2) != null) continue;
            this.gui.setItem(i2, list2.get(i2));
        }
    }

    public void fillSide(@NotNull Side side, @NotNull List<GuiItem> list) {
        switch (side.ordinal()) {
            case 0: {
                this.fillBetweenPoints(1, 1, this.gui.getRows(), 1, list);
                break;
            }
            case 1: {
                this.fillBetweenPoints(1, 9, this.gui.getRows(), 9, list);
                break;
            }
            case 2: {
                this.fillSide(Side.LEFT, list);
                this.fillSide(Side.RIGHT, list);
            }
        }
    }

    private List<GuiItem> repeatList(@NotNull List<GuiItem> list) {
        ArrayList<GuiItem> arrayList = new ArrayList<GuiItem>();
        Collections.nCopies(this.gui.getRows() * 9, list).forEach(arrayList::addAll);
        return arrayList;
    }

    private int getSlotFromRowCol(int n2, int n3) {
        return n3 + (n2 - 1) * 9 - 1;
    }

    public static enum Side {
        LEFT,
        RIGHT,
        BOTH;

    }
}

