/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.components;

import me.ulrich.clans.library.gui.components.GuiType;
import me.ulrich.clans.library.gui.components.InventoryProvider;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public interface GuiContainer {
    @NotNull
    public Component title();

    public void title(@NotNull Component var1);

    @NotNull
    public Inventory createInventory(@NotNull InventoryHolder var1);

    @NotNull
    public GuiType guiType();

    public int inventorySize();

    public int rows();

    public static class Typed
    implements GuiContainer {
        private final InventoryProvider.Typed inventoryProvider;
        private final GuiType guiType;
        private Component title;

        public Typed(@NotNull Component component, @NotNull InventoryProvider.Typed typed, @NotNull GuiType guiType) {
            this.inventoryProvider = typed;
            this.title = component;
            this.guiType = guiType;
        }

        @Override
        @NotNull
        public Component title() {
            return this.title;
        }

        @Override
        public void title(@NotNull Component component) {
            this.title = component;
        }

        @Override
        public int inventorySize() {
            return this.guiType.getLimit();
        }

        @Override
        @NotNull
        public GuiType guiType() {
            return this.guiType;
        }

        @Override
        public int rows() {
            return 1;
        }

        @Override
        @NotNull
        public Inventory createInventory(@NotNull InventoryHolder inventoryHolder) {
            return this.inventoryProvider.getInventory(this.title, inventoryHolder, this.guiType.getInventoryType());
        }
    }

    public static class Chest
    implements GuiContainer {
        private final InventoryProvider.Chest inventoryProvider;
        private int rows;
        private Component title;

        public Chest(@NotNull Component component, @NotNull InventoryProvider.Chest chest, int n2) {
            this.inventoryProvider = chest;
            this.title = component;
            this.rows = n2;
        }

        @Override
        @NotNull
        public Component title() {
            return this.title;
        }

        @Override
        public void title(@NotNull Component component) {
            this.title = component;
        }

        @Override
        public int inventorySize() {
            return this.rows * 9;
        }

        @Override
        @NotNull
        public GuiType guiType() {
            return GuiType.CHEST;
        }

        @Override
        public int rows() {
            return this.rows;
        }

        public void rows(int n2) {
            this.rows = n2;
        }

        @Override
        @NotNull
        public Inventory createInventory(@NotNull InventoryHolder inventoryHolder) {
            return this.inventoryProvider.getInventory(this.title, inventoryHolder, this.inventorySize());
        }
    }
}

