/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.item;

import java.util.Arrays;
import java.util.List;
import me.ulrich.clans.library.gui.builder.item.BaseItemBuilder;
import me.ulrich.clans.library.gui.builder.item.NameLoreHandler;
import me.ulrich.clans.library.gui.components.exception.GuiException;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FireworkBuilder
extends BaseItemBuilder<FireworkBuilder> {
    private static final Material STAR = Material.FIREWORK_STAR;
    private static final Material ROCKET = Material.FIREWORK_ROCKET;

    FireworkBuilder(@NotNull ItemStack itemStack, @NotNull NameLoreHandler nameLoreHandler) {
        super(itemStack, nameLoreHandler);
        if (itemStack.getType() != STAR && itemStack.getType() != ROCKET) {
            throw new GuiException("FireworkBuilder requires the material to be a FIREWORK_STAR/FIREWORK_ROCKET!");
        }
    }

    @NotNull
    @Contract(value="_ -> this")
    public FireworkBuilder effect(FireworkEffect ... fireworkEffectArray) {
        return this.effect(Arrays.asList(fireworkEffectArray));
    }

    @NotNull
    @Contract(value="_ -> this")
    public FireworkBuilder effect(@NotNull List<FireworkEffect> list) {
        if (list.isEmpty()) {
            return this;
        }
        if (this.getItemStack().getType() == STAR) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)this.getMeta();
            fireworkEffectMeta.setEffect(list.get(0));
            this.setMeta((ItemMeta)fireworkEffectMeta);
            return this;
        }
        FireworkMeta fireworkMeta = (FireworkMeta)this.getMeta();
        fireworkMeta.addEffects(list);
        this.setMeta((ItemMeta)fireworkMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public FireworkBuilder power(int n2) {
        if (this.getItemStack().getType() == ROCKET) {
            FireworkMeta fireworkMeta = (FireworkMeta)this.getMeta();
            fireworkMeta.setPower(n2);
            this.setMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }
}

