/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.item;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.ulrich.clans.library.gui.builder.item.NameLoreHandler;
import me.ulrich.clans.library.gui.components.exception.GuiException;
import me.ulrich.clans.library.gui.components.util.Legacy;
import me.ulrich.clans.library.gui.components.util.VersionHelper;
import me.ulrich.clans.library.kyori.adventure.platform.bukkit.MinecraftComponentSerializer;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitNameLoreHandler
implements NameLoreHandler {
    private static final Field DISPLAY_NAME_FIELD;
    private static final Field LORE_FIELD;
    private static final BukkitNameLoreHandler INSTANCE;

    @NotNull
    public static BukkitNameLoreHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void name(@NotNull ItemMeta itemMeta, @NotNull Component component) {
        if (VersionHelper.IS_COMPONENT_LEGACY) {
            itemMeta.setDisplayName(Legacy.SERIALIZER.serialize(component));
            return;
        }
        try {
            DISPLAY_NAME_FIELD.set(itemMeta, this.serializeComponent(component));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GuiException("Could not set display name for ItemBuilder.", illegalAccessException);
        }
    }

    @Override
    public void lore(@NotNull ItemMeta itemMeta, @NotNull List<Component> list) {
        if (VersionHelper.IS_COMPONENT_LEGACY) {
            itemMeta.setLore(list.stream().filter(Objects::nonNull).map(Legacy.SERIALIZER::serialize).collect(Collectors.toList()));
            return;
        }
        List list2 = list.stream().filter(Objects::nonNull).map(this::serializeComponent).collect(Collectors.toList());
        try {
            LORE_FIELD.set(itemMeta, list2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GuiException("Could not set lore for ItemBuilder.", illegalAccessException);
        }
    }

    @Override
    public void lore(@NotNull ItemMeta itemMeta, @NotNull Consumer<List<@Nullable Component>> consumer) {
        ArrayList<Component> arrayList;
        if (VersionHelper.IS_COMPONENT_LEGACY) {
            List list = itemMeta.getLore();
            arrayList = list == null ? new ArrayList<Component>() : list.stream().map(Legacy.SERIALIZER::deserialize).collect(Collectors.toList());
        } else {
            try {
                List list = (List)LORE_FIELD.get(itemMeta);
                arrayList = list == null ? new ArrayList() : list.stream().map(this::deserializeComponent).collect(Collectors.toList());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new GuiException("Could not get lore for ItemBuilder.", illegalAccessException);
            }
        }
        consumer.accept(arrayList);
        this.lore(itemMeta, arrayList);
    }

    @NotNull
    private Object serializeComponent(@NotNull Component component) {
        if (VersionHelper.IS_ITEM_NAME_COMPONENT) {
            return MinecraftComponentSerializer.get().serialize(component);
        }
        return GsonComponentSerializer.gson().serialize(component);
    }

    @NotNull
    private Component deserializeComponent(@NotNull Object object) {
        if (VersionHelper.IS_ITEM_NAME_COMPONENT) {
            return MinecraftComponentSerializer.get().deserialize(object);
        }
        return GsonComponentSerializer.gson().deserialize((String)object);
    }

    static {
        INSTANCE = new BukkitNameLoreHandler();
        try {
            Class<?> clazz = VersionHelper.craftClass("inventory.CraftMetaItem");
            DISPLAY_NAME_FIELD = clazz.getDeclaredField("displayName");
            DISPLAY_NAME_FIELD.setAccessible(true);
            LORE_FIELD = clazz.getDeclaredField("lore");
            LORE_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            throw new GuiException("Could not retrieve displayName nor lore field for ItemBuilder.", reflectiveOperationException);
        }
    }
}

