/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.item;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import me.ulrich.clans.library.gui.builder.item.BaseItemBuilder;
import me.ulrich.clans.library.gui.builder.item.NameLoreHandler;
import me.ulrich.clans.library.gui.components.exception.GuiException;
import me.ulrich.clans.library.gui.components.util.Legacy;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookBuilder
extends BaseItemBuilder<BookBuilder> {
    private static final EnumSet<Material> BOOKS = EnumSet.of(Material.WRITABLE_BOOK, Material.WRITTEN_BOOK);

    BookBuilder(@NotNull ItemStack itemStack, @NotNull NameLoreHandler nameLoreHandler) {
        super(itemStack, nameLoreHandler);
        if (!BOOKS.contains(itemStack.getType())) {
            throw new GuiException("BookBuilder requires the material to be a WRITABLE_BOOK/WRITTEN_BOOK!");
        }
    }

    @NotNull
    @Contract(value="_ -> this")
    public BookBuilder author(@Nullable Component component) {
        BookMeta bookMeta = (BookMeta)this.getMeta();
        if (component == null) {
            bookMeta.setAuthor(null);
            this.setMeta((ItemMeta)bookMeta);
            return this;
        }
        bookMeta.setAuthor(Legacy.SERIALIZER.serialize(component));
        this.setMeta((ItemMeta)bookMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public BookBuilder generation(@Nullable BookMeta.Generation generation) {
        BookMeta bookMeta = (BookMeta)this.getMeta();
        bookMeta.setGeneration(generation);
        this.setMeta((ItemMeta)bookMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public BookBuilder page(Component ... componentArray) {
        return this.page(Arrays.asList(componentArray));
    }

    @NotNull
    @Contract(value="_ -> this")
    public BookBuilder page(@NotNull List<Component> list) {
        BookMeta bookMeta = (BookMeta)this.getMeta();
        for (Component component : list) {
            bookMeta.addPage(new String[]{Legacy.SERIALIZER.serialize(component)});
        }
        this.setMeta((ItemMeta)bookMeta);
        return this;
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public BookBuilder page(int n2, @NotNull Component component) {
        BookMeta bookMeta = (BookMeta)this.getMeta();
        bookMeta.setPage(n2, Legacy.SERIALIZER.serialize(component));
        this.setMeta((ItemMeta)bookMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public BookBuilder title(@Nullable Component component) {
        BookMeta bookMeta = (BookMeta)this.getMeta();
        if (component == null) {
            bookMeta.setTitle(null);
            this.setMeta((ItemMeta)bookMeta);
            return this;
        }
        bookMeta.setTitle(Legacy.SERIALIZER.serialize(component));
        this.setMeta((ItemMeta)bookMeta);
        return this;
    }
}

