/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.item;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.ulrich.clans.library.gui.builder.item.NameLoreHandler;
import me.ulrich.clans.library.gui.components.GuiAction;
import me.ulrich.clans.library.gui.components.util.ItemNbt;
import me.ulrich.clans.library.gui.components.util.VersionHelper;
import me.ulrich.clans.library.gui.guis.GuiItem;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseItemBuilder<B extends BaseItemBuilder<B>> {
    private static final EnumSet<Material> LEATHER_ARMOR = EnumSet.of(Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS);
    private ItemStack itemStack;
    private ItemMeta meta;
    private final NameLoreHandler nameLoreHandler;

    protected BaseItemBuilder(@NotNull ItemStack itemStack, @NotNull NameLoreHandler nameLoreHandler) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"Item can't be null!");
        this.itemStack = itemStack;
        this.nameLoreHandler = nameLoreHandler;
        this.meta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
    }

    @NotNull
    @Contract(value="_ -> this")
    public B name(@NotNull Component component) {
        this.nameLoreHandler.name(this.meta, component);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B amount(int n2) {
        this.itemStack.setAmount(n2);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B lore(Component ... componentArray) {
        return this.lore(Arrays.asList(componentArray));
    }

    @NotNull
    @Contract(value="_ -> this")
    public B lore(@NotNull List<@Nullable Component> list) {
        this.nameLoreHandler.lore(this.meta, list);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B lore(@NotNull Consumer<List<@Nullable Component>> consumer) {
        this.nameLoreHandler.lore(this.meta, consumer);
        return (B)this;
    }

    @NotNull
    @Contract(value="_, _, _ -> this")
    public B enchant(@NotNull Enchantment enchantment, int n2, boolean bl) {
        this.meta.addEnchant(enchantment, n2, bl);
        return (B)this;
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public B enchant(@NotNull Enchantment enchantment, int n2) {
        return this.enchant(enchantment, n2, true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B enchant(@NotNull Enchantment enchantment) {
        return this.enchant(enchantment, 1, true);
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public B enchant(@NotNull Map<Enchantment, Integer> map, boolean bl) {
        map.forEach((enchantment, n2) -> this.enchant((Enchantment)enchantment, (int)n2, bl));
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B enchant(@NotNull Map<Enchantment, Integer> map) {
        return this.enchant(map, true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B disenchant(@NotNull Enchantment enchantment) {
        this.itemStack.removeEnchantment(enchantment);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B flags(ItemFlag ... itemFlagArray) {
        this.meta.addItemFlags(itemFlagArray);
        return (B)this;
    }

    @NotNull
    @Contract(value=" -> this")
    public B unbreakable() {
        return this.unbreakable(true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B unbreakable(boolean bl) {
        if (VersionHelper.IS_UNBREAKABLE_LEGACY) {
            return this.setNbt("Unbreakable", bl);
        }
        this.meta.setUnbreakable(bl);
        return (B)this;
    }

    @NotNull
    @Contract(value=" -> this")
    public B glow() {
        return this.glow(true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B glow(boolean bl) {
        if (bl) {
            this.meta.addEnchant(Enchantment.LURE, 1, false);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            return (B)this;
        }
        for (Enchantment enchantment : this.meta.getEnchants().keySet()) {
            this.meta.removeEnchant(enchantment);
        }
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B pdc(@NotNull Consumer<PersistentDataContainer> consumer) {
        consumer.accept(this.meta.getPersistentDataContainer());
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B model(int n2) {
        if (VersionHelper.IS_CUSTOM_MODEL_DATA) {
            this.meta.setCustomModelData(Integer.valueOf(n2));
        }
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B color(@NotNull Color color) {
        if (LEATHER_ARMOR.contains(this.itemStack.getType())) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.getMeta();
            leatherArmorMeta.setColor(color);
            this.setMeta((ItemMeta)leatherArmorMeta);
        }
        return (B)this;
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public B setNbt(@NotNull String string, @NotNull String string2) {
        this.itemStack.setItemMeta(this.meta);
        this.itemStack = ItemNbt.setString(this.itemStack, string, string2);
        this.meta = this.itemStack.getItemMeta();
        return (B)this;
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public B setNbt(@NotNull String string, boolean bl) {
        this.itemStack.setItemMeta(this.meta);
        this.itemStack = ItemNbt.setBoolean(this.itemStack, string, bl);
        this.meta = this.itemStack.getItemMeta();
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B removeNbt(@NotNull String string) {
        this.itemStack.setItemMeta(this.meta);
        this.itemStack = ItemNbt.removeTag(this.itemStack, string);
        this.meta = this.itemStack.getItemMeta();
        return (B)this;
    }

    @NotNull
    public ItemStack build() {
        this.itemStack.setItemMeta(this.meta);
        return this.itemStack;
    }

    @NotNull
    @Contract(value=" -> new")
    public GuiItem asGuiItem() {
        return new GuiItem(this.build());
    }

    @NotNull
    @Contract(value="_ -> new")
    public GuiItem asGuiItem(@NotNull GuiAction<InventoryClickEvent> guiAction) {
        return new GuiItem(this.build(), guiAction);
    }

    @NotNull
    protected ItemStack getItemStack() {
        return this.itemStack;
    }

    protected void setItemStack(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @NotNull
    protected ItemMeta getMeta() {
        return this.meta;
    }

    protected void setMeta(@NotNull ItemMeta itemMeta) {
        this.meta = itemMeta;
    }

    @Deprecated
    public B setName(@NotNull String string) {
        this.getMeta().setDisplayName(string);
        return (B)this;
    }

    @Deprecated
    public B setAmount(int n2) {
        this.getItemStack().setAmount(n2);
        return (B)this;
    }

    @Deprecated
    public B addLore(String ... stringArray) {
        return this.addLore(Arrays.asList(stringArray));
    }

    @Deprecated
    public B addLore(@NotNull List<String> list) {
        List<String> list2 = this.getMeta().hasLore() ? this.getMeta().getLore() : new ArrayList();
        list2.addAll(list);
        return this.setLore(list2);
    }

    @Deprecated
    public B setLore(String ... stringArray) {
        return this.setLore(Arrays.asList(stringArray));
    }

    @Deprecated
    public B setLore(@NotNull List<String> list) {
        this.getMeta().setLore(list);
        return (B)this;
    }

    @Deprecated
    public B addEnchantment(@NotNull Enchantment enchantment, int n2, boolean bl) {
        this.getMeta().addEnchant(enchantment, n2, bl);
        return (B)this;
    }

    @Deprecated
    public B addEnchantment(@NotNull Enchantment enchantment, int n2) {
        return this.addEnchantment(enchantment, n2, true);
    }

    @Deprecated
    public B addEnchantment(@NotNull Enchantment enchantment) {
        return this.addEnchantment(enchantment, 1, true);
    }

    @Deprecated
    public B removeEnchantment(@NotNull Enchantment enchantment) {
        this.getItemStack().removeEnchantment(enchantment);
        return (B)this;
    }

    @Deprecated
    public B addItemFlags(ItemFlag ... itemFlagArray) {
        this.getMeta().addItemFlags(itemFlagArray);
        return (B)this;
    }

    @Deprecated
    public B setUnbreakable(boolean bl) {
        return this.unbreakable(bl);
    }
}

