/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.item;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import me.ulrich.clans.library.gui.builder.item.BaseItemBuilder;
import me.ulrich.clans.library.gui.builder.item.NameLoreHandler;
import me.ulrich.clans.library.gui.components.exception.GuiException;
import me.ulrich.clans.library.gui.components.util.VersionHelper;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class BannerBuilder
extends BaseItemBuilder<BannerBuilder> {
    private static final Material DEFAULT_BANNER;
    private static final EnumSet<Material> BANNERS;

    BannerBuilder(@NotNull NameLoreHandler nameLoreHandler) {
        super(new ItemStack(DEFAULT_BANNER), nameLoreHandler);
    }

    BannerBuilder(@NotNull ItemStack itemStack, @NotNull NameLoreHandler nameLoreHandler) {
        super(itemStack, nameLoreHandler);
        if (!BANNERS.contains(itemStack.getType())) {
            throw new GuiException("BannerBuilder requires the material to be a banner!");
        }
    }

    @NotNull
    @Contract(value="_ -> this")
    public BannerBuilder baseColor(@NotNull DyeColor dyeColor) {
        BannerMeta bannerMeta = (BannerMeta)this.getMeta();
        bannerMeta.setBaseColor(dyeColor);
        this.setMeta((ItemMeta)bannerMeta);
        return this;
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public BannerBuilder pattern(@NotNull DyeColor dyeColor, @NotNull PatternType patternType) {
        BannerMeta bannerMeta = (BannerMeta)this.getMeta();
        bannerMeta.addPattern(new Pattern(dyeColor, patternType));
        this.setMeta((ItemMeta)bannerMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public BannerBuilder pattern(Pattern ... patternArray) {
        return this.pattern(Arrays.asList(patternArray));
    }

    @NotNull
    @Contract(value="_ -> this")
    public BannerBuilder pattern(@NotNull List<Pattern> list) {
        BannerMeta bannerMeta = (BannerMeta)this.getMeta();
        for (Pattern pattern : list) {
            bannerMeta.addPattern(pattern);
        }
        this.setMeta((ItemMeta)bannerMeta);
        return this;
    }

    @NotNull
    @Contract(value="_, _, _ -> this")
    public BannerBuilder pattern(int n2, @NotNull DyeColor dyeColor, @NotNull PatternType patternType) {
        return this.pattern(n2, new Pattern(dyeColor, patternType));
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public BannerBuilder pattern(int n2, @NotNull Pattern pattern) {
        BannerMeta bannerMeta = (BannerMeta)this.getMeta();
        bannerMeta.setPattern(n2, pattern);
        this.setMeta((ItemMeta)bannerMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public BannerBuilder setPatterns(@NotNull @NotNull List<@NotNull Pattern> list) {
        BannerMeta bannerMeta = (BannerMeta)this.getMeta();
        bannerMeta.setPatterns(list);
        this.setMeta((ItemMeta)bannerMeta);
        return this;
    }

    static {
        if (VersionHelper.IS_ITEM_LEGACY) {
            DEFAULT_BANNER = Material.valueOf((String)"BANNER");
            BANNERS = EnumSet.of(Material.valueOf((String)"BANNER"));
        } else {
            DEFAULT_BANNER = Material.WHITE_BANNER;
            BANNERS = EnumSet.copyOf(Tag.BANNERS.getValues());
        }
    }
}

