/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.gui;

import java.util.function.Consumer;
import me.ulrich.clans.library.gui.builder.gui.BaseGuiBuilder;
import me.ulrich.clans.library.gui.builder.gui.ChestGuiBuilder;
import me.ulrich.clans.library.gui.components.GuiContainer;
import me.ulrich.clans.library.gui.components.GuiType;
import me.ulrich.clans.library.gui.components.InventoryProvider;
import me.ulrich.clans.library.gui.components.util.Legacy;
import me.ulrich.clans.library.gui.guis.Gui;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TypedGuiBuilder
extends BaseGuiBuilder<Gui, TypedGuiBuilder> {
    private GuiType guiType;
    private InventoryProvider.Typed inventoryProvider = (component, inventoryHolder, inventoryType) -> Bukkit.createInventory((InventoryHolder)inventoryHolder, (InventoryType)inventoryType, (String)Legacy.SERIALIZER.serialize(component));

    public TypedGuiBuilder(@NotNull GuiType guiType) {
        this.guiType = guiType;
    }

    public TypedGuiBuilder(@NotNull GuiType guiType, @NotNull ChestGuiBuilder chestGuiBuilder) {
        this.guiType = guiType;
        this.consumeBuilder(chestGuiBuilder);
    }

    @NotNull
    @Contract(value="_ -> this")
    public TypedGuiBuilder type(@NotNull GuiType guiType) {
        this.guiType = guiType;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public TypedGuiBuilder inventory(@NotNull InventoryProvider.Typed typed) {
        this.inventoryProvider = typed;
        return this;
    }

    @Override
    @NotNull
    @Contract(value=" -> new")
    public Gui create() {
        Gui gui = new Gui(new GuiContainer.Typed(this.getTitle(), this.inventoryProvider, this.guiType), this.getModifiers());
        Consumer consumer = this.getConsumer();
        if (consumer != null) {
            consumer.accept(gui);
        }
        return gui;
    }
}

