/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.gui.builder.gui;

import me.ulrich.clans.library.gui.builder.gui.BaseGuiBuilder;
import me.ulrich.clans.library.gui.components.GuiContainer;
import me.ulrich.clans.library.gui.components.InventoryProvider;
import me.ulrich.clans.library.gui.components.util.Legacy;
import me.ulrich.clans.library.gui.guis.BaseGui;
import org.bukkit.Bukkit;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class BaseChestGuiBuilder<G extends BaseGui, B extends BaseChestGuiBuilder<G, B>>
extends BaseGuiBuilder<G, B> {
    private int rows = 1;
    private InventoryProvider.Chest inventoryProvider = (component, inventoryHolder, n2) -> Bukkit.createInventory((InventoryHolder)inventoryHolder, (int)n2, (String)Legacy.SERIALIZER.serialize(component));

    @NotNull
    @Contract(value="_ -> this")
    public B rows(int n2) {
        this.rows = n2;
        return (B)this;
    }

    public B inventory(@NotNull InventoryProvider.Chest chest) {
        this.inventoryProvider = chest;
        return (B)this;
    }

    protected int getRows() {
        return this.rows;
    }

    @NotNull
    protected InventoryProvider.Chest getInventoryProvider() {
        return this.inventoryProvider;
    }

    @NotNull
    protected GuiContainer.Chest createContainer() {
        return new GuiContainer.Chest(this.getTitle(), this.inventoryProvider, this.getRows());
    }
}

