/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.enumconfig.yaml.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.ulrich.clans.library.enumconfig.library.Yaml;
import me.ulrich.clans.library.enumconfig.yaml.EnumConfigurationConstructor;
import me.ulrich.clans.library.enumconfig.yaml.EnumConfigurationDumperOptions;
import me.ulrich.clans.library.enumconfig.yaml.EnumConfigurationRepresenter;
import me.ulrich.clans.library.enumconfig.yaml.file.MemorySection;
import me.ulrich.clans.library.enumconfig.yaml.file.interfaces.Configuration;
import me.ulrich.clans.library.enumconfig.yaml.file.interfaces.ConfigurationSection;

public class YAMLConfiguration
extends MemorySection
implements Configuration {
    private final EnumConfigurationDumperOptions dumperOptions;
    private final Yaml yaml;
    private final File file;
    private HashMap<String, String> comments = new HashMap();

    public YAMLConfiguration(File file, EnumConfigurationDumperOptions enumConfigurationDumperOptions) {
        this.file = file;
        this.dumperOptions = enumConfigurationDumperOptions;
        this.yaml = new Yaml(new EnumConfigurationConstructor(), new EnumConfigurationRepresenter(), enumConfigurationDumperOptions);
    }

    public void load() {
        LinkedHashMap linkedHashMap = null;
        try {
            linkedHashMap = (LinkedHashMap)this.yaml.load(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            this.tryCopyFileUsingStream(this.file, new File(this.file.getPath() + "_backup_" + new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss").format(Calendar.getInstance().getTime())));
            exception.printStackTrace();
        }
        if (linkedHashMap != null) {
            this.convertMapsToSections(linkedHashMap, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCopyFileUsingStream(File file, File file2) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n2;
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public File getFile() {
        return this.file;
    }

    private void convertMapsToSections(LinkedHashMap<String, Object> linkedHashMap, ConfigurationSection configurationSection) {
        for (Map.Entry<String, Object> entry : linkedHashMap.entrySet()) {
            try {
                String string = entry.getKey();
                Object object = entry.getValue();
                if (object instanceof LinkedHashMap) {
                    this.convertMapsToSections((LinkedHashMap)object, configurationSection.createSection(string));
                    continue;
                }
                configurationSection.set(string, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void save() {
        if (this.file == null) {
            throw new NullPointerException("File cannot be null");
        }
        File file = this.file.getCanonicalFile().getParentFile();
        if (file == null) {
            return;
        }
        if (file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + this.file);
        }
        String string = this.yaml.dump(this.getValues(false));
        if (string.equals("{}\n")) {
            string = "";
        }
        String[] stringArray = string.split(System.getProperty("line.separator"));
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        int n2 = 0;
        for (String string3 : stringArray) {
            boolean bl = false;
            if (string3.contains(": ") || string3.length() > 1 && string3.charAt(string3.length() - 1) == ':') {
                bl = true;
                int n3 = string3.indexOf(": ");
                if (n3 < 0) {
                    n3 = string3.length() - 1;
                }
                if (string2.isEmpty()) {
                    string2 = string3.substring(0, n3);
                } else {
                    int n4;
                    int n5 = 0;
                    for (n4 = 0; n4 < string3.length() && string3.charAt(n4) == ' '; ++n4) {
                        ++n5;
                    }
                    if (n5 / this.dumperOptions.getIndent() > n2) {
                        string2 = string2 + this.dumperOptions.getSeparatorChar() + string3.substring(n5, n3);
                        ++n2;
                    } else if (n5 / this.dumperOptions.getIndent() < n2) {
                        int n6;
                        n4 = n5 / this.dumperOptions.getIndent();
                        for (n6 = 0; n6 < n2 - n4; ++n6) {
                            string2 = string2.replace(string2.substring(string2.lastIndexOf(this.dumperOptions.getSeparatorChar())), "");
                        }
                        n6 = string2.lastIndexOf(this.dumperOptions.getSeparatorChar());
                        if (n6 < 0) {
                            string2 = "";
                        } else {
                            string2 = string2.replace(string2.substring(string2.lastIndexOf(this.dumperOptions.getSeparatorChar())), "");
                            string2 = string2 + this.dumperOptions.getSeparatorChar();
                        }
                        string2 = string2 + string3.substring(n5, n3);
                        n2 = n4;
                    } else {
                        n4 = string2.lastIndexOf(this.dumperOptions.getSeparatorChar());
                        if (n4 < 0) {
                            string2 = "";
                        } else {
                            string2 = string2.replace(string2.substring(string2.lastIndexOf(this.dumperOptions.getSeparatorChar())), "");
                            string2 = string2 + this.dumperOptions.getSeparatorChar();
                        }
                        string2 = string2 + string3.substring(n5, n3);
                    }
                }
            }
            if (bl && this.comments.get(string2) != null) {
                string3 = this.comments.get(string2) + string3;
            }
            stringBuilder.append(string3).append(System.getProperty("line.separator"));
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);){
            outputStreamWriter.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public ConfigurationSection getParent() {
        return null;
    }

    public void setComments(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != this.dumperOptions.getSeparatorChar()) continue;
            for (int i3 = 0; i3 < this.dumperOptions.getIndent(); ++i3) {
                stringBuilder2.append(" ");
            }
        }
        for (String string2 : stringArray) {
            stringBuilder.append((CharSequence)stringBuilder2).append(string2).append(System.getProperty("line.separator"));
        }
        this.comments.put(string, stringBuilder.toString());
    }

    @Override
    public char getSeparatorCharacter() {
        return this.dumperOptions.getSeparatorChar();
    }
}

