/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.enumconfig.yaml.file;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.enumconfig.yaml.file.interfaces.Configuration;
import me.ulrich.clans.library.enumconfig.yaml.file.interfaces.ConfigurationSection;

public class MemorySection
implements ConfigurationSection {
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final Configuration root;
    private final ConfigurationSection parent;
    private final String path;
    private final String fullPath;

    MemorySection() {
        if (!(this instanceof Configuration)) {
            throw new IllegalStateException("Cannot construct a root MemorySection when not a Configuration");
        }
        this.path = "";
        this.fullPath = "";
        this.parent = null;
        this.root = (Configuration)((Object)this);
    }

    private MemorySection(ConfigurationSection configurationSection, String string) {
        if (configurationSection == null) {
            throw new NullPointerException("Parent cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("Path cannot be null");
        }
        this.path = string;
        this.parent = configurationSection;
        this.root = configurationSection.getRoot();
        if (this.root == null) {
            throw new NullPointerException("Path cannot be orphaned");
        }
        this.fullPath = MemorySection.createPath(configurationSection, string);
    }

    private static String createPath(ConfigurationSection configurationSection, String string) {
        if (configurationSection == null) {
            throw new NullPointerException("Cannot create path without a section");
        }
        return MemorySection.createPath(configurationSection, string, configurationSection.getRoot());
    }

    private static String createPath(ConfigurationSection configurationSection, String string, ConfigurationSection configurationSection2) {
        if (configurationSection == null) {
            throw new NullPointerException("Cannot create path without a section");
        }
        Configuration configuration = configurationSection.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot create path without a root");
        }
        char c2 = configurationSection.getRoot().getSeparatorCharacter();
        StringBuilder stringBuilder = new StringBuilder();
        for (ConfigurationSection configurationSection3 = configurationSection; configurationSection3 != null && configurationSection3 != configurationSection2; configurationSection3 = configurationSection3.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, c2);
            }
            stringBuilder.insert(0, configurationSection3.getName());
        }
        if (string != null && string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<String> getKeys(boolean bl) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.mapChildrenKeys(linkedHashSet, this, bl);
        return linkedHashSet;
    }

    @Override
    public LinkedHashMap<String, Object> getValues(boolean bl) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        this.mapChildrenValues(linkedHashMap, this, bl);
        return linkedHashMap;
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public boolean isSet(String string) {
        return this.contains(string);
    }

    @Override
    public String getCurrentPath() {
        return this.fullPath;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public Configuration getRoot() {
        return this.root;
    }

    @Override
    public ConfigurationSection getParent() {
        return this.parent;
    }

    @Override
    public void set(String string, Object object) {
        String string2;
        int n2;
        if (string == null) {
            throw new NullPointerException("Cannot set to an empty path");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot set to an empty path");
        }
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot use section without a root");
        }
        char c2 = this.getRoot().getSeparatorCharacter();
        int n3 = -1;
        ConfigurationSection configurationSection = this;
        while ((n3 = string.indexOf(c2, n2 = n3 + 1)) != -1) {
            string2 = string.substring(n2, n3);
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string2);
            if (configurationSection2 == null) {
                if (object == null) {
                    return;
                }
                configurationSection = configurationSection.createSection(string2);
                continue;
            }
            configurationSection = configurationSection2;
        }
        string2 = string.substring(n2);
        if (configurationSection == this) {
            if (object == null) {
                this.map.remove(string2);
            } else {
                this.map.put(string2, object);
            }
        } else {
            configurationSection.set(string2, object);
        }
    }

    @Override
    public Object get(String string) {
        int n2;
        if (string.length() == 0) {
            return this;
        }
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot access section without a root");
        }
        char c2 = this.getRoot().getSeparatorCharacter();
        int n3 = -1;
        ConfigurationSection configurationSection = this;
        while ((n3 = string.indexOf(c2, n2 = n3 + 1)) != -1) {
            if ((configurationSection = configurationSection.getConfigurationSection(string.substring(n2, n3))) != null) continue;
            return null;
        }
        String string2 = string.substring(n2);
        if (configurationSection == this) {
            return this.map.get(string2);
        }
        return configurationSection.get(string2);
    }

    @Override
    public ConfigurationSection createSection(String string) {
        ConfigurationSection configurationSection;
        String string2;
        int n2;
        if (string == null) {
            throw new NullPointerException("Cannot create section at empty path");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot create section at empty path");
        }
        Configuration configuration = this.getRoot();
        if (configuration == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        char c2 = this.getRoot().getSeparatorCharacter();
        int n3 = -1;
        ConfigurationSection configurationSection2 = this;
        while ((n3 = string.indexOf(c2, n2 = n3 + 1)) != -1) {
            string2 = string.substring(n2, n3);
            configurationSection = configurationSection2.getConfigurationSection(string2);
            if (configurationSection == null) {
                configurationSection2 = configurationSection2.createSection(string2);
                continue;
            }
            configurationSection2 = configurationSection;
        }
        string2 = string.substring(n2);
        if (configurationSection2 == this) {
            configurationSection = new MemorySection(this, string2);
            this.map.put(string2, configurationSection);
            return configurationSection;
        }
        return configurationSection2.createSection(string2);
    }

    @Override
    public ConfigurationSection createSection(String string, LinkedHashMap<String, Object> linkedHashMap) {
        ConfigurationSection configurationSection = this.createSection(string);
        for (Map.Entry<String, Object> entry : linkedHashMap.entrySet()) {
            if (entry.getValue() instanceof LinkedHashMap) {
                configurationSection.createSection(entry.getKey(), (LinkedHashMap)entry.getValue());
                continue;
            }
            configurationSection.set(entry.getKey(), entry.getValue());
        }
        return configurationSection;
    }

    @Override
    public ConfigurationSection getConfigurationSection(String string) {
        Object object = this.get(string);
        if (object instanceof ConfigurationSection) {
            return (ConfigurationSection)object;
        }
        return null;
    }

    @Override
    public boolean isConfigurationSection(String string) {
        Object object = this.get(string);
        return object instanceof ConfigurationSection;
    }

    private void mapChildrenKeys(Set<String> set, ConfigurationSection configurationSection, boolean bl) {
        if (configurationSection instanceof MemorySection) {
            MemorySection memorySection = (MemorySection)configurationSection;
            for (Map.Entry<String, Object> entry : memorySection.map.entrySet()) {
                set.add(MemorySection.createPath(configurationSection, entry.getKey(), this));
                if (!bl || !(entry.getValue() instanceof ConfigurationSection)) continue;
                ConfigurationSection configurationSection2 = (ConfigurationSection)entry.getValue();
                this.mapChildrenKeys(set, configurationSection2, bl);
            }
        } else {
            Set<String> set2 = configurationSection.getKeys(bl);
            for (String string : set2) {
                set.add(MemorySection.createPath(configurationSection, string, this));
            }
        }
    }

    private void mapChildrenValues(Map<String, Object> map, ConfigurationSection configurationSection, boolean bl) {
        if (configurationSection instanceof MemorySection) {
            MemorySection memorySection = (MemorySection)configurationSection;
            for (Map.Entry<String, Object> entry : memorySection.map.entrySet()) {
                map.put(MemorySection.createPath(configurationSection, entry.getKey(), this), entry.getValue());
                if (!(entry.getValue() instanceof ConfigurationSection) || !bl) continue;
                this.mapChildrenValues(map, (ConfigurationSection)entry.getValue(), bl);
            }
        } else {
            LinkedHashMap<String, Object> linkedHashMap = configurationSection.getValues(bl);
            for (Map.Entry<String, Object> entry : linkedHashMap.entrySet()) {
                map.put(MemorySection.createPath(configurationSection, entry.getKey(), this), entry.getValue());
            }
        }
    }
}

