/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.enumconfig.library.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import me.ulrich.clans.library.enumconfig.library.error.YAMLException;
import me.ulrich.clans.library.enumconfig.library.external.com.google.gdata.util.common.base.Escaper;
import me.ulrich.clans.library.enumconfig.library.external.com.google.gdata.util.common.base.PercentEscaper;

public abstract class UriEncoder {
    private static final CharsetDecoder UTF8Decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
    private static final String SAFE_CHARS = "-_.!~*'()@:$&,;=[]/";
    private static final Escaper escaper = new PercentEscaper("-_.!~*'()@:$&,;=[]/", false);

    public static String encode(String string) {
        return escaper.escape(string);
    }

    public static String decode(ByteBuffer byteBuffer) {
        CharBuffer charBuffer = UTF8Decoder.decode(byteBuffer);
        return charBuffer.toString();
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new YAMLException(unsupportedEncodingException);
        }
    }
}

