/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.enumconfig;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.ulrich.clans.library.enumconfig.EnumConfiguration;
import me.ulrich.clans.library.enumconfig.interfaces.ConfigurationEnum;
import me.ulrich.clans.library.enumconfig.library.DumperOptions;
import me.ulrich.clans.library.enumconfig.yaml.EnumConfigurationDumperOptions;

public class EnumConfigurationBuilder {
    private File file;
    private List<ConfigurationEnum> configurationEnums;
    private EnumConfigurationDumperOptions dumperOptions = new EnumConfigurationDumperOptions();

    public <T extends Enum<T>> EnumConfigurationBuilder(File file, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("EnumClass is Null!");
        }
        this.file = file;
        this.configurationEnums = new ArrayList<T>(Arrays.asList(clazz.getEnumConstants()));
    }

    EnumConfigurationBuilder(File file, List<ConfigurationEnum> list, EnumConfigurationDumperOptions enumConfigurationDumperOptions) {
        this.file = file;
        this.configurationEnums = list;
        this.dumperOptions = enumConfigurationDumperOptions;
    }

    public EnumConfigurationBuilder setWidth(int n2) {
        this.dumperOptions.setWidth(n2);
        return this;
    }

    public EnumConfigurationBuilder setIndentation(int n2) {
        if (n2 < 2 || n2 > 9) {
            throw new IllegalArgumentException("Indentation cannot be smaller than 2 or larger than 9");
        }
        this.dumperOptions.setIndent(n2);
        return this;
    }

    public EnumConfigurationBuilder setIndicatorIndentation(int n2) {
        this.dumperOptions.setIndicatorIndent(n2);
        return this;
    }

    public EnumConfigurationBuilder setLineBreak(DumperOptions.LineBreak lineBreak) {
        this.dumperOptions.setLineBreak(lineBreak);
        return this;
    }

    public EnumConfigurationBuilder setSeparatorCharacter(char c2) {
        this.dumperOptions.setSeparatorChar(c2);
        return this;
    }

    public EnumConfigurationBuilder addConfigurationEnumeration(ConfigurationEnum ... configurationEnumArray) {
        for (ConfigurationEnum configurationEnum : configurationEnumArray) {
            for (ConfigurationEnum configurationEnum2 : this.configurationEnums) {
                if (configurationEnum.equals(configurationEnum2)) {
                    throw new IllegalArgumentException("You cannot add identical ConfigurationEnums!");
                }
                if (configurationEnum.getPath().equalsIgnoreCase(configurationEnum2.getPath())) {
                    throw new IllegalArgumentException("You cannot add two ConfigurationEnums with the same path!");
                }
                this.configurationEnums.add(configurationEnum);
            }
        }
        return this;
    }

    public EnumConfiguration build(String string) {
        return new EnumConfiguration(string, this.file, this.configurationEnums, this.dumperOptions);
    }
}

