/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.enumconfig;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.ulrich.clans.library.enumconfig.interfaces.ConfigurationEnum;
import me.ulrich.clans.library.enumconfig.yaml.EnumConfigurationDumperOptions;
import me.ulrich.clans.library.enumconfig.yaml.file.YAMLConfiguration;
import me.ulrich.clans.library.enumconfig.yaml.file.interfaces.ConfigurationSection;

public class EnumConfiguration {
    private YAMLConfiguration configuration;
    private YAMLConfiguration oldConfiguration;
    private List<ConfigurationEnum> configurationEnums;
    private String pluginTag;

    EnumConfiguration(String string, File file, List<ConfigurationEnum> list, EnumConfigurationDumperOptions enumConfigurationDumperOptions) {
        try {
            if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                throw new IOException("Parent folder was a file, not directory");
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("File couldn't be created");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.pluginTag = string;
        this.oldConfiguration = new YAMLConfiguration(file, enumConfigurationDumperOptions);
        try {
            this.oldConfiguration.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.configurationEnums = list;
        this.configuration = new YAMLConfiguration(file, enumConfigurationDumperOptions);
        this.buildConfig();
    }

    private void buildConfig() {
        for (ConfigurationEnum configurationEnum : this.configurationEnums) {
            if (configurationEnum.getComments().length > 0) {
                this.configuration.setComments(configurationEnum.getPath(), configurationEnum.getComments());
            }
            if (this.oldConfiguration.get(configurationEnum.getPath()) != null) {
                this.configuration.set(configurationEnum.getPath(), this.oldConfiguration.get(configurationEnum.getPath()));
                continue;
            }
            this.configuration.set(configurationEnum.getPath(), configurationEnum.getDefaultValue());
        }
        try {
            this.configuration.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void set(ConfigurationEnum configurationEnum, Object object) {
        this.configuration.set(configurationEnum.getPath(), object);
        try {
            this.configuration.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public YAMLConfiguration getYaml() {
        return this.configuration;
    }

    public Object get(ConfigurationEnum configurationEnum) {
        return this.configuration.get(configurationEnum.getPath());
    }

    public String getString(ConfigurationEnum configurationEnum) {
        String string = this.get(configurationEnum).toString();
        string = this.fingArgs(string, null);
        return string;
    }

    public String getString(ConfigurationEnum configurationEnum, List<String> list) {
        String string = this.get(configurationEnum).toString();
        string = this.fingArgs(string, list);
        return string;
    }

    public String fingArgs(String string, List<String> list) {
        String string2 = string;
        string2 = string2.replace("%tag%", this.getPluginTag());
        if (list == null) {
            return string2;
        }
        if (list.size() == 0) {
            return string2;
        }
        for (String string3 : list) {
            if (string3 == null || string3.isEmpty()) continue;
            String[] stringArray = string3.split(";");
            string2 = string2.replace(stringArray[0], stringArray[1]);
        }
        return string2;
    }

    public boolean isString(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof String;
    }

    public int getInteger(ConfigurationEnum configurationEnum) {
        return (Integer)this.get(configurationEnum);
    }

    public boolean isInteger(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof Integer;
    }

    public boolean getBoolean(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return (Boolean)object;
    }

    public boolean isBoolean(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof Boolean;
    }

    public double getDouble(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return (Double)object;
    }

    public boolean isDouble(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof Double;
    }

    public long getLong(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return (Long)object;
    }

    public boolean isLong(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof Long;
    }

    public ConfigurationSection getConfigurationSection(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return (ConfigurationSection)object;
    }

    public boolean isConfigurationSection(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof ConfigurationSection;
    }

    public List<?> getList(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return (List)object;
    }

    public boolean isList(ConfigurationEnum configurationEnum) {
        Object object = this.get(configurationEnum);
        return object instanceof List;
    }

    public List<String> getStringList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object obj : list) {
            if (!(obj instanceof String)) continue;
            String string = String.valueOf(obj);
            string = this.fingArgs(string, null);
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getStringList(ConfigurationEnum configurationEnum, List<String> list) {
        List<?> list2 = this.getList(configurationEnum);
        if (list2 == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object obj : list2) {
            if (!(obj instanceof String)) continue;
            String string = String.valueOf(obj);
            string = this.fingArgs(string, list);
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<Integer> getIntegerList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object obj : list) {
            if (obj instanceof Integer) {
                arrayList.add((Integer)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Integer.valueOf((String)obj));
                }
                catch (Exception exception) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Integer.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).intValue());
        }
        return arrayList;
    }

    public List<Boolean> getBooleanList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (Object obj : list) {
            if (obj instanceof Boolean) {
                arrayList.add((Boolean)obj);
                continue;
            }
            if (!(obj instanceof String)) continue;
            if (Boolean.TRUE.toString().equals(obj)) {
                arrayList.add(true);
                continue;
            }
            if (!Boolean.FALSE.toString().equals(obj)) continue;
            arrayList.add(false);
        }
        return arrayList;
    }

    public List<Double> getDoubleList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Object obj : list) {
            if (obj instanceof Double) {
                arrayList.add((Double)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Double.valueOf((String)obj));
                }
                catch (Exception exception) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Double.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).doubleValue());
        }
        return arrayList;
    }

    public List<Float> getFloatList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (Object obj : list) {
            if (obj instanceof Float) {
                arrayList.add((Float)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Float.valueOf((String)obj));
                }
                catch (Exception exception) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Float.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(Float.valueOf(((Number)obj).floatValue()));
        }
        return arrayList;
    }

    public List<Long> getLongList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Object obj : list) {
            if (obj instanceof Long) {
                arrayList.add((Long)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Long.valueOf((String)obj));
                }
                catch (Exception exception) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add(Long.valueOf(((Character)obj).charValue()));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).longValue());
        }
        return arrayList;
    }

    public List<Byte> getByteList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Byte>();
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (Object obj : list) {
            if (obj instanceof Byte) {
                arrayList.add((Byte)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Byte.valueOf((String)obj));
                }
                catch (Exception exception) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add((byte)((Character)obj).charValue());
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).byteValue());
        }
        return arrayList;
    }

    public List<Character> getCharacterList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (Object obj : list) {
            if (obj instanceof Character) {
                arrayList.add((Character)obj);
                continue;
            }
            if (obj instanceof String) {
                String string = (String)obj;
                if (string.length() != 1) continue;
                arrayList.add(Character.valueOf(string.charAt(0)));
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(Character.valueOf((char)((Number)obj).intValue()));
        }
        return arrayList;
    }

    public List<Short> getShortList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        if (list == null) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> arrayList = new ArrayList<Short>();
        for (Object obj : list) {
            if (obj instanceof Short) {
                arrayList.add((Short)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(Short.valueOf((String)obj));
                }
                catch (Exception exception) {}
                continue;
            }
            if (obj instanceof Character) {
                arrayList.add((short)((Character)obj).charValue());
                continue;
            }
            if (!(obj instanceof Number)) continue;
            arrayList.add(((Number)obj).shortValue());
        }
        return arrayList;
    }

    public List<Map<?, ?>> getMapList(ConfigurationEnum configurationEnum) {
        List<?> list = this.getList(configurationEnum);
        ArrayList arrayList = new ArrayList();
        if (list == null) {
            return arrayList;
        }
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            arrayList.add((Map)obj);
        }
        return arrayList;
    }

    public void addConfigurationEnumeration(ConfigurationEnum[] configurationEnumArray) {
        ArrayList<ConfigurationEnum> arrayList = new ArrayList<ConfigurationEnum>();
        for (ConfigurationEnum configurationEnum : configurationEnumArray) {
            for (ConfigurationEnum configurationEnum2 : this.configurationEnums) {
                if (configurationEnum.equals(configurationEnum2)) {
                    throw new IllegalArgumentException("You cannot add identical ConfigurationEnums!");
                }
                if (configurationEnum.getPath().equalsIgnoreCase(configurationEnum2.getPath())) {
                    throw new IllegalArgumentException("You cannot add two ConfigurationEnums with the same path!");
                }
                arrayList.add(configurationEnum);
            }
        }
        this.configurationEnums.addAll(arrayList);
        this.buildConfig();
    }

    public String getPluginTag() {
        return this.pluginTag;
    }
}

