/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.interfaces;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import me.ulrich.clans.Clans;
import me.ulrich.clans.data.Flag;
import me.ulrich.clans.interfaces.ClansCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public abstract class CommandHandler
implements CommandExecutor {
    protected final Map<String, ClansCommand> registeredCommands = new HashMap<String, ClansCommand>();
    protected final Map<String, CommandHandler> registeredHandlers = new HashMap<String, CommandHandler>();
    protected Clans plugin;
    protected String cmd;

    public CommandHandler(Clans clans, String string) {
        this.plugin = clans;
        this.cmd = string;
    }

    public void registerCommand(String string, ClansCommand clansCommand) {
        if (this.registeredCommands.containsKey(string) && this.plugin.getFiles().k().getBoolean("Config.debug_errors")) {
            this.plugin.getLogger().warning("The alias command '" + string + "' appears repeated. ");
        }
        this.registeredCommands.put(string, clansCommand);
    }

    public Map<String, ClansCommand> registered() {
        return this.registeredCommands;
    }

    public void unregisterCommand(String string) {
        this.registeredCommands.remove(string);
    }

    public void registerHandler(CommandHandler commandHandler) {
        if (this.registeredHandlers.containsKey(commandHandler.getCommand())) {
            this.plugin.getLogger().warning("Replacing existing handler for: " + commandHandler.getCommand());
        }
        this.registeredHandlers.put(commandHandler.getCommand(), commandHandler);
    }

    public void unregisterHandler(String string) {
        this.registeredHandlers.remove(string);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        EnumMap<Flag, String> enumMap = new EnumMap<Flag, String>(Flag.class);
        if (this.plugin.getFiles().a(commandSender) == null) {
            return false;
        }
        enumMap.put(Flag.TAG, this.plugin.getTagpl());
        if (stringArray.length == 0) {
            return this.noArgs(commandSender, command, string, enumMap);
        }
        String string2 = stringArray[0].toLowerCase();
        CommandHandler commandHandler = this.registeredHandlers.get(string2);
        if (commandHandler != null) {
            return commandHandler.onCommand(commandSender, command, string, this.shortenArgs(stringArray));
        }
        ClansCommand clansCommand = this.registeredCommands.get(string2);
        if (clansCommand == null) {
            return this.unknownCommand(commandSender, command, string, stringArray, enumMap);
        }
        boolean bl = true;
        try {
            bl = clansCommand.execute(this.plugin, commandSender, command, string, this.shortenArgs(stringArray), enumMap);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            this.plugin.getMessageManager().a(commandSender, this.plugin.getTagpl() + "<red>Missing parameters.");
        }
        return bl;
    }

    public abstract boolean noArgs(CommandSender var1, Command var2, String var3, EnumMap<Flag, String> var4);

    public abstract boolean unknownCommand(CommandSender var1, Command var2, String var3, String[] var4, EnumMap<Flag, String> var5);

    protected String[] shortenArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList.toArray(new String[0]);
    }

    public String getCommand() {
        return this.cmd;
    }
}

