/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.data;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import me.ulrich.clans.Clans;
import me.ulrich.clans.c.a.a;
import me.ulrich.clans.c.i;
import me.ulrich.clans.manager.I;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Extension {
    private boolean enabled;
    private i dataSerializer;
    private i configSerializer;
    private JavaPlugin instance;
    private String name;
    private String author;
    private String version;
    private String require;
    private String description;
    private a classLoader;
    private File extensionDataFolder;
    private HashMap<String, InputStream> extensionFiles;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public JavaPlugin getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public a getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(a a2) {
        this.classLoader = a2;
    }

    public File getExtensionDataFolder() {
        return this.extensionDataFolder;
    }

    public void enable(JavaPlugin javaPlugin, File file, i i2, i i3) {
        try {
            if (this.isEnabled()) {
                this.instance.getLogger().warning("Error extension: " + file.getName() + ", The extension is already enabled.");
            }
            this.instance = javaPlugin;
            this.extensionDataFolder = file;
            this.dataSerializer = i2;
            this.configSerializer = i3;
            file.mkdirs();
            this.onEnable();
            this.setEnabled(true);
        }
        catch (Exception exception) {
            this.logThis(exception);
        }
    }

    protected boolean logThis(Exception exception) {
        try {
            String string = ExceptionUtils.getStackTrace((Throwable)exception);
            new I((Clans)Bukkit.getPluginManager().getPlugin("UltimateClans")).a(string, "extension-" + this.extensionDataFolder.getName() + "-stacktrace");
            this.instance.getLogger().warning("Error extension: " + this.extensionDataFolder.getName() + ", StackTrace: saved in /logs/extension-" + this.extensionDataFolder.getName() + "-stacktrace.log");
            return true;
        }
        catch (ClassCastException classCastException) {
            this.instance.getLogger().warning("Error extension: " + this.extensionDataFolder.getName() + ", StackTrace: Error to save log!");
            return false;
        }
    }

    public void disable() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Cannot disable the extension when it isn't enabled");
        }
        this.onDisable();
        this.setEnabled(false);
    }

    public abstract void onEnable();

    public abstract void onDisable();

    public i getDataSerializer() {
        return this.dataSerializer;
    }

    public i getConfigSerializer() {
        return this.configSerializer;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public HashMap<String, InputStream> getAddonFiles() {
        return this.extensionFiles;
    }

    public void setAddonFiles(HashMap<String, InputStream> hashMap) {
        this.extensionFiles = hashMap;
    }

    public String getRequire() {
        return this.require;
    }

    public void setRequire(String string) {
        this.require = string;
    }
}

