/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import me.ulrich.clans.library.universalScheduler.scheduling.schedulers.TaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Metrics {
    private final Plugin plugin;
    private final f metricsBase;

    public Metrics(JavaPlugin javaPlugin, int n2, TaskScheduler taskScheduler) {
        this.plugin = javaPlugin;
        File file = new File(javaPlugin.getDataFolder().getParentFile(), "bStats");
        File file2 = new File(file, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
        if (!yamlConfiguration.isSet("serverUuid")) {
            yamlConfiguration.addDefault("enabled", (Object)true);
            yamlConfiguration.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            yamlConfiguration.addDefault("logFailedRequests", (Object)false);
            yamlConfiguration.addDefault("logSentData", (Object)false);
            yamlConfiguration.addDefault("logResponseStatusText", (Object)false);
            yamlConfiguration.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
            try {
                yamlConfiguration.save(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean bl = yamlConfiguration.getBoolean("enabled", true);
        String string2 = yamlConfiguration.getString("serverUuid");
        boolean bl2 = yamlConfiguration.getBoolean("logFailedRequests", false);
        boolean bl3 = yamlConfiguration.getBoolean("logSentData", false);
        boolean bl4 = yamlConfiguration.getBoolean("logResponseStatusText", false);
        this.metricsBase = new f("bukkit", string2, n2, bl, this::appendPlatformData, this::appendServiceData, runnable -> taskScheduler.runTask((Runnable)runnable), () -> ((JavaPlugin)javaPlugin).isEnabled(), (string, throwable) -> this.plugin.getLogger().log(Level.WARNING, (String)string, (Throwable)throwable), string -> this.plugin.getLogger().log(Level.INFO, (String)string), bl2, bl3, bl4);
    }

    public void shutdown() {
        this.metricsBase.a();
    }

    public void addCustomChart(c c2) {
        this.metricsBase.a(c2);
    }

    private void appendPlatformData(e e2) {
        e2.a("playerAmount", this.getPlayerAmount());
        e2.a("onlineMode", Bukkit.getOnlineMode() ? 1 : 0);
        e2.a("bukkitVersion", Bukkit.getVersion());
        e2.a("bukkitName", Bukkit.getName());
        e2.a("javaVersion", System.getProperty("java.version"));
        e2.a("osName", System.getProperty("os.name"));
        e2.a("osArch", System.getProperty("os.arch"));
        e2.a("osVersion", System.getProperty("os.version"));
        e2.a("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(e e2) {
        e2.a("pluginVersion", this.plugin.getDescription().getVersion());
    }

    private int getPlayerAmount() {
        try {
            Method method = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            return method.getReturnType().equals(Collection.class) ? ((Collection)method.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])method.invoke((Object)Bukkit.getServer(), new Object[0])).length;
        }
        catch (Exception exception) {
            return Bukkit.getOnlinePlayers().size();
        }
    }

    public static class f {
        public static final String a = "3.0.2";
        private static final String b = "https://bStats.org/api/v2/data/%s";
        private final ScheduledExecutorService c;
        private final String d;
        private final String e;
        private final int f;
        private final Consumer<e> g;
        private final Consumer<e> h;
        private final Consumer<Runnable> i;
        private final Supplier<Boolean> j;
        private final BiConsumer<String, Throwable> k;
        private final Consumer<String> l;
        private final boolean m;
        private final boolean n;
        private final boolean o;
        private final Set<c> p = new HashSet<c>();
        private final boolean q;

        public f(String string, String string2, int n2, boolean bl, Consumer<e> consumer, Consumer<e> consumer2, Consumer<Runnable> consumer3, Supplier<Boolean> supplier, BiConsumer<String, Throwable> biConsumer, Consumer<String> consumer4, boolean bl2, boolean bl3, boolean bl4) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, runnable -> new Thread(runnable, "bStats-Metrics"));
            scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.c = scheduledThreadPoolExecutor;
            this.d = string;
            this.e = string2;
            this.f = n2;
            this.q = bl;
            this.g = consumer;
            this.h = consumer2;
            this.i = consumer3;
            this.j = supplier;
            this.k = biConsumer;
            this.l = consumer4;
            this.m = bl2;
            this.n = bl3;
            this.o = bl4;
            this.d();
            if (bl) {
                this.b();
            }
        }

        public void a(c c2) {
            this.p.add(c2);
        }

        public void a() {
            this.c.shutdown();
        }

        private void b() {
            Runnable runnable = () -> {
                if (!this.q || !this.j.get().booleanValue()) {
                    this.c.shutdown();
                    return;
                }
                if (this.i != null) {
                    this.i.accept(this::c);
                } else {
                    this.c();
                }
            };
            long l2 = (long)(60000.0 * (3.0 + Math.random() * 3.0));
            long l3 = (long)(60000.0 * (Math.random() * 30.0));
            this.c.schedule(runnable, l2, TimeUnit.MILLISECONDS);
            this.c.scheduleAtFixedRate(runnable, l2 + l3, 1800000L, TimeUnit.MILLISECONDS);
        }

        private void c() {
            e e2 = new e();
            this.g.accept(e2);
            e e3 = new e();
            this.h.accept(e3);
            e.a[] aArray = (e.a[])this.p.stream().map(c2 -> c2.a(this.k, this.m)).filter(Objects::nonNull).toArray(e.a[]::new);
            e3.a("id", this.f);
            e3.a("customCharts", aArray);
            e2.a("service", e3.a());
            e2.a("serverUUID", this.e);
            e2.a("metricsVersion", a);
            e.a a2 = e2.a();
            this.c.execute(() -> {
                block2: {
                    try {
                        this.a(a2);
                    }
                    catch (Exception exception) {
                        if (!this.m) break block2;
                        this.k.accept("Could not submit bStats metrics data", exception);
                    }
                }
            });
        }

        private void a(e.a a2) {
            if (this.n) {
                this.l.accept("Sent bStats metrics data: " + a2.toString());
            }
            String string = String.format(b, this.d);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(string).openConnection();
            byte[] byArray = me.ulrich.clans.Metrics$f.a(a2.toString());
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.addRequestProperty("Accept", "application/json");
            httpsURLConnection.addRequestProperty("Connection", "close");
            httpsURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpsURLConnection.addRequestProperty("Content-Length", String.valueOf(byArray.length));
            httpsURLConnection.setRequestProperty("Content-Type", "application/json");
            httpsURLConnection.setRequestProperty("User-Agent", "Metrics-Service/1");
            httpsURLConnection.setDoOutput(true);
            try (Object object = new DataOutputStream(httpsURLConnection.getOutputStream());){
                ((FilterOutputStream)object).write(byArray);
            }
            object = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    ((StringBuilder)object).append(string2);
                }
            }
            if (this.o) {
                this.l.accept("Sent data to bStats and received response: " + object);
            }
        }

        private void d() {
            if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
                String string = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
                String string2 = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
                if (f.class.getPackage().getName().startsWith(string) || f.class.getPackage().getName().startsWith(string2)) {
                    throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
                }
            }
        }

        private static byte[] a(String string) {
            if (string == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static abstract class c {
        private final String a;

        protected c(String string) {
            if (string == null) {
                throw new IllegalArgumentException("chartId must not be null");
            }
            this.a = string;
        }

        public e.a a(BiConsumer<String, Throwable> biConsumer, boolean bl) {
            e e2 = new e();
            e2.a("chartId", this.a);
            try {
                e.a a2 = this.a();
                if (a2 == null) {
                    return null;
                }
                e2.a("data", a2);
            }
            catch (Throwable throwable) {
                if (bl) {
                    biConsumer.accept("Failed to get data for custom chart with id " + this.a, throwable);
                }
                return null;
            }
            return e2.a();
        }

        protected abstract e.a a();
    }

    public static class e {
        private StringBuilder a = new StringBuilder();
        private boolean b = false;

        public e() {
            this.a.append("{");
        }

        public e a(String string) {
            this.b(string, "null");
            return this;
        }

        public e a(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("JSON value must not be null");
            }
            this.b(string, "\"" + e.b(string2) + "\"");
            return this;
        }

        public e a(String string, int n2) {
            this.b(string, String.valueOf(n2));
            return this;
        }

        public e a(String string, a a2) {
            if (a2 == null) {
                throw new IllegalArgumentException("JSON object must not be null");
            }
            this.b(string, a2.toString());
            return this;
        }

        public e a(String string2, String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String string3 = Arrays.stream(stringArray).map(string -> "\"" + e.b(string) + "\"").collect(Collectors.joining(","));
            this.b(string2, "[" + string3 + "]");
            return this;
        }

        public e a(String string, int[] nArray) {
            if (nArray == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String string2 = Arrays.stream(nArray).mapToObj(String::valueOf).collect(Collectors.joining(","));
            this.b(string, "[" + string2 + "]");
            return this;
        }

        public e a(String string, a[] aArray) {
            if (aArray == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String string2 = Arrays.stream(aArray).map(a::toString).collect(Collectors.joining(","));
            this.b(string, "[" + string2 + "]");
            return this;
        }

        private void b(String string, String string2) {
            if (this.a == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            if (string == null) {
                throw new IllegalArgumentException("JSON key must not be null");
            }
            if (this.b) {
                this.a.append(",");
            }
            this.a.append("\"").append(e.b(string)).append("\":").append(string2);
            this.b = true;
        }

        public a a() {
            if (this.a == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            a a2 = new a(this.a.append("}").toString(), null);
            this.a = null;
            return a2;
        }

        private static String b(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\"') {
                    stringBuilder.append("\\\"");
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                if (c2 <= '\u000f') {
                    stringBuilder.append("\\u000").append(Integer.toHexString(c2));
                    continue;
                }
                if (c2 <= '\u001f') {
                    stringBuilder.append("\\u00").append(Integer.toHexString(c2));
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }

        public static class a {
            private final String a;

            private a(String string) {
                this.a = string;
            }

            public String toString() {
                return this.a;
            }

            /* synthetic */ a(String string, me.ulrich.clans.a a2) {
                this(string);
            }
        }
    }

    public static class j
    extends c {
        private final Callable<Integer> a;

        public j(String string, Callable<Integer> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        protected e.a a() {
            int n2 = this.a.call();
            if (n2 == 0) {
                return null;
            }
            return new e().a("value", n2).a();
        }
    }

    public static class d
    extends c {
        private final Callable<Map<String, Map<String, Integer>>> a;

        public d(String string, Callable<Map<String, Map<String, Integer>>> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        public e.a a() {
            e e2 = new e();
            Map<String, Map<String, Integer>> map = this.a.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Map<String, Integer>> entry : map.entrySet()) {
                e e3 = new e();
                boolean bl2 = true;
                for (Map.Entry<String, Integer> entry2 : map.get(entry.getKey()).entrySet()) {
                    e3.a(entry2.getKey(), entry2.getValue());
                    bl2 = false;
                }
                if (bl2) continue;
                bl = false;
                e2.a(entry.getKey(), e3.a());
            }
            if (bl) {
                return null;
            }
            return new e().a("values", e2.a()).a();
        }
    }

    public static class a
    extends c {
        private final Callable<Map<String, int[]>> a;

        public a(String string, Callable<Map<String, int[]>> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        protected e.a a() {
            e e2 = new e();
            Map<String, int[]> map = this.a.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                bl = false;
                e2.a(entry.getKey(), entry.getValue());
            }
            if (bl) {
                return null;
            }
            return new e().a("values", e2.a()).a();
        }
    }

    public static class h
    extends c {
        private final Callable<Map<String, Integer>> a;

        public h(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        protected e.a a() {
            e e2 = new e();
            Map<String, Integer> map = this.a.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                e2.a(entry.getKey(), new int[]{entry.getValue()});
            }
            return new e().a("values", e2.a()).a();
        }
    }

    public static class b
    extends c {
        private final Callable<Map<String, Integer>> a;

        public b(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        protected e.a a() {
            e e2 = new e();
            Map<String, Integer> map = this.a.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                e2.a(entry.getKey(), entry.getValue());
            }
            if (bl) {
                return null;
            }
            return new e().a("values", e2.a()).a();
        }
    }

    public static class g
    extends c {
        private final Callable<Map<String, Integer>> a;

        public g(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        protected e.a a() {
            e e2 = new e();
            Map<String, Integer> map = this.a.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                e2.a(entry.getKey(), entry.getValue());
            }
            if (bl) {
                return null;
            }
            return new e().a("values", e2.a()).a();
        }
    }

    public static class i
    extends c {
        private final Callable<String> a;

        public i(String string, Callable<String> callable) {
            super(string);
            this.a = callable;
        }

        @Override
        protected e.a a() {
            String string = this.a.call();
            if (string == null || string.isEmpty()) {
                return null;
            }
            return new e().a("value", string).a();
        }
    }
}

