/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.item;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import de.tim2byte.tBLib.TBLib;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    private static final MiniMessage mm = MiniMessage.miniMessage();
    private final ItemMeta itemMeta;
    private final ItemStack itemStack;

    public ItemBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int amount) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
        this.setAmount(amount);
    }

    public ItemBuilder(OfflinePlayer player) {
        this.itemStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
        skullMeta.setOwningPlayer(player);
        this.itemMeta = skullMeta;
    }

    public ItemBuilder(String headTexture) {
        this.itemStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
        PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
        profile.setProperty(new ProfileProperty("textures", headTexture));
        skullMeta.setPlayerProfile(profile);
        this.itemMeta = skullMeta;
    }

    public ItemBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemMeta = itemStack.getItemMeta();
    }

    public ItemBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemBuilder setMaxStack(int amount) {
        this.itemMeta.setMaxStackSize(Integer.valueOf(amount));
        return this;
    }

    public ItemBuilder setName(@Nullable Component component) {
        this.itemMeta.displayName(component);
        return this;
    }

    public ItemBuilder setName(String name) {
        this.setName(mm.deserialize((Object)name));
        return this;
    }

    public ItemBuilder addLore(Object ... objects) {
        ArrayList<Component> lore = new ArrayList<Component>();
        if (this.itemMeta.hasLore()) {
            lore.addAll(Objects.requireNonNull(this.itemMeta.lore()));
        }
        for (Object object : objects) {
            if (object instanceof String) {
                String string = (String)object;
                lore.add(mm.deserialize((Object)string));
                continue;
            }
            if (object instanceof Component) {
                Component component = (Component)object;
                lore.add(component);
                continue;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (Object entry : list) {
                if (entry instanceof String) {
                    String s = (String)entry;
                    lore.add(mm.deserialize((Object)s));
                    continue;
                }
                if (!(entry instanceof Component)) continue;
                Component c = (Component)entry;
                lore.add(c);
            }
        }
        this.itemMeta.lore(lore);
        return this;
    }

    public ItemBuilder addLoreIf(boolean condition, Object ... objects) {
        if (condition) {
            return this.addLore(objects);
        }
        return this;
    }

    public ItemBuilder addLoreIf(Supplier<Boolean> condition, Object ... objects) {
        if (condition.get().booleanValue()) {
            return this.addLore(objects);
        }
        return this;
    }

    public ItemBuilder overwriteLore(Object ... o) {
        this.itemMeta.lore(new ArrayList());
        return this.addLore(o);
    }

    public ItemBuilder setRarity(ItemRarity rarity) {
        this.itemMeta.setRarity(rarity);
        return this;
    }

    public ItemBuilder hide() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_STORED_ENCHANTS});
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        return this;
    }

    public ItemBuilder shine() {
        this.itemMeta.addEnchant(Enchantment.UNBREAKING, 1, true);
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... s) {
        this.itemMeta.addItemFlags(s);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment e, int level) {
        this.itemMeta.addEnchant(e, level, true);
        return this;
    }

    public ItemBuilder addAllEnchantments(boolean minecraftOnly) {
        return this.addAllEnchantments(true, minecraftOnly);
    }

    public ItemBuilder addAllEnchantments(boolean shuffle, boolean minecraftOnly) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>(RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).stream().filter(enchantment -> {
            if (!minecraftOnly) {
                return true;
            }
            return enchantment.getKey().getNamespace().equals("minecraft");
        }).toList());
        if (shuffle) {
            Collections.shuffle(enchantments);
        }
        for (Enchantment enchantment2 : enchantments) {
            if (this.itemMeta.getEnchants().keySet().stream().anyMatch(e -> e.conflictsWith(enchantment2)) || !enchantment2.canEnchantItem(this.itemStack) || enchantment2.isCursed()) continue;
            this.itemMeta.addEnchant(enchantment2, enchantment2.getMaxLevel(), true);
        }
        return this;
    }

    public ItemBuilder addRandomEnchantments(int amount, boolean randomLevel, boolean minecraftOnly) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>(RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).stream().filter(enchantment -> {
            if (!minecraftOnly) {
                return true;
            }
            return enchantment.getKey().getNamespace().equals("minecraft");
        }).toList());
        Collections.shuffle(enchantments);
        for (Enchantment enchantment2 : enchantments) {
            if (this.itemMeta.getEnchants().keySet().stream().anyMatch(e -> e.conflictsWith(enchantment2)) && !this.itemStack.getType().equals((Object)Material.ENCHANTED_BOOK)) continue;
            if (enchantment2.canEnchantItem(this.itemStack) && !enchantment2.isCursed() || this.itemStack.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                int level = randomLevel ? 1 + (int)(Math.random() * (double)enchantment2.getMaxLevel()) : enchantment2.getMaxLevel();
                this.itemMeta.addEnchant(enchantment2, level, true);
            }
            if (this.itemMeta.getEnchants().size() < amount) continue;
            break;
        }
        return this;
    }

    public ItemBuilder setMaxDurability(int amount) {
        this.itemStack.setData(DataComponentTypes.MAX_DAMAGE, (Object)amount);
        return this;
    }

    public ItemBuilder setID(String id) {
        this.itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)TBLib.getPlugin(), "CUSTOM_ID"), PersistentDataType.STRING, (Object)id);
        return this;
    }

    public static boolean hasIDKey(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        NamespacedKey customIDKey = new NamespacedKey((Plugin)TBLib.getPlugin(), "CUSTOM_ID");
        return itemMeta.getPersistentDataContainer().has(customIDKey, PersistentDataType.STRING);
    }

    public static boolean hasID(ItemStack item, String id) {
        return ItemBuilder.getID(item).equals(id);
    }

    public static String getID(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (!ItemBuilder.hasIDKey(item)) {
            return "";
        }
        NamespacedKey customIDKey = new NamespacedKey((Plugin)TBLib.getPlugin(), "CUSTOM_ID");
        String storedItemID = (String)itemMeta.getPersistentDataContainer().get(customIDKey, PersistentDataType.STRING);
        if (storedItemID == null) {
            return "";
        }
        return storedItemID;
    }

    public ItemBuilder setExtraData(String key, String data) {
        return this.setExtraData(new NamespacedKey((Plugin)TBLib.getPlugin(), key), data);
    }

    public ItemBuilder setExtraData(NamespacedKey key, String data) {
        this.itemMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)data);
        return this;
    }

    public <T, Z> ItemBuilder setExtraData(String key, PersistentDataType<T, Z> type, Z data) {
        return this.setExtraData(new NamespacedKey((Plugin)TBLib.getPlugin(), key), type, data);
    }

    public <T, Z> ItemBuilder setExtraData(NamespacedKey key, PersistentDataType<T, Z> type, Z data) {
        this.itemMeta.getPersistentDataContainer().set(key, type, data);
        return this;
    }

    public static String getExtraData(ItemStack item, String key) {
        return ItemBuilder.getExtraData(item, new NamespacedKey((Plugin)TBLib.getPlugin(), key));
    }

    public static String getExtraData(ItemStack item, NamespacedKey namespacedKey) {
        ItemMeta itemMeta = item.getItemMeta();
        if (!itemMeta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.STRING)) {
            return "";
        }
        return (String)itemMeta.getPersistentDataContainer().get(namespacedKey, PersistentDataType.STRING);
    }

    public static <T, Z> Z getExtraData(ItemStack item, String key, PersistentDataType<T, Z> dataType, Z backup) {
        return ItemBuilder.getExtraData(item, new NamespacedKey((Plugin)TBLib.getPlugin(), key), dataType, backup);
    }

    public static <T, Z> Z getExtraData(ItemStack item, NamespacedKey key, PersistentDataType<T, Z> dataType, Z backup) {
        ItemMeta itemMeta = item.getItemMeta();
        return (Z)(item.getPersistentDataContainer().has(key, dataType) ? itemMeta.getPersistentDataContainer().get(key, dataType) : backup);
    }

    public static boolean hasExtraData(ItemStack item, String key) {
        return ItemBuilder.hasExtraData(item, new NamespacedKey((Plugin)TBLib.getPlugin(), key));
    }

    public static boolean hasExtraData(ItemStack item, NamespacedKey namespacedKey) {
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta.getPersistentDataContainer().has(namespacedKey);
    }

    public static boolean hasExtraData(ItemStack item, String key, PersistentDataType<?, ?> dataType) {
        return ItemBuilder.hasExtraData(item, new NamespacedKey((Plugin)TBLib.getPlugin(), key), dataType);
    }

    public static boolean hasExtraData(ItemStack item, NamespacedKey namespacedKey, PersistentDataType<?, ?> dataType) {
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta.getPersistentDataContainer().has(namespacedKey, dataType);
    }

    public static ItemStack removeExtraData(ItemStack item, String key) {
        return ItemBuilder.removeExtraData(item, new NamespacedKey((Plugin)TBLib.getPlugin(), key));
    }

    public static ItemStack removeExtraData(ItemStack item, NamespacedKey key) {
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.getPersistentDataContainer().remove(key);
        item.setItemMeta(itemMeta);
        return item;
    }

    public ItemBuilder makeFood(int nutrition, int saturation, float seconds, boolean canAlwaysEat, PotionEffect ... effect) {
        this.itemStack.setData(DataComponentTypes.CONSUMABLE, (Object)(effect == null ? (Consumable)Consumable.consumable().consumeSeconds(seconds).build() : (Consumable)Consumable.consumable().consumeSeconds(seconds).addEffect((ConsumeEffect)ConsumeEffect.applyStatusEffects(Arrays.asList(effect), (float)1.0f)).build()));
        this.itemStack.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)FoodProperties.food().nutrition(nutrition).saturation((float)saturation).canAlwaysEat(canAlwaysEat).build()));
        return this;
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

