/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.Utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern COLOR_TAG_PATTERN = Pattern.compile("<[^>]+>");

    private static int getVisibleLength(String str) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        return COLOR_TAG_PATTERN.matcher(str).replaceAll("").length();
    }

    public static List<String> splitIntoSegments(String message, int maxLength) {
        return StringUtils.splitIntoSegments(message, maxLength, "");
    }

    public static List<String> splitIntoSegments(String message, int maxLength, String prefix) {
        ArrayList<String> parts = new ArrayList<String>();
        if (message == null || message.isBlank()) {
            return parts;
        }
        String[] words = message.split(" ");
        StringBuilder currentSegment = new StringBuilder();
        int currentVisibleLength = 0;
        for (String word : words) {
            int prefixVisibleLength;
            if (word.isEmpty()) continue;
            int wordVisibleLength = StringUtils.getVisibleLength(word);
            if (wordVisibleLength + (prefixVisibleLength = StringUtils.getVisibleLength(prefix)) > maxLength) {
                if (currentVisibleLength > 0) {
                    parts.add(prefix + currentSegment.toString());
                    currentSegment.setLength(0);
                    currentVisibleLength = 0;
                }
                parts.add(prefix + word);
                continue;
            }
            int lengthWithNewWord = currentVisibleLength + (currentVisibleLength > 0 ? 1 : 0) + wordVisibleLength;
            if (prefixVisibleLength + lengthWithNewWord > maxLength) {
                parts.add(prefix + currentSegment.toString());
                currentSegment.setLength(0);
                currentSegment.append(word);
                currentVisibleLength = wordVisibleLength;
                continue;
            }
            if (currentVisibleLength > 0) {
                currentSegment.append(" ");
            }
            currentSegment.append(word);
            currentVisibleLength = lengthWithNewWord;
        }
        if (currentVisibleLength > 0) {
            parts.add(prefix + currentSegment.toString());
        }
        return parts;
    }
}

