/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.Config;

import de.tim2byte.tBLib.TBLib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CConfig
extends YamlConfiguration {
    private final File file;
    private static final ArrayList<CConfig> instances = new ArrayList();

    public CConfig(String path, String name, @Nullable String presetFileName) {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Could not create directory: " + path);
        }
        this.file = new File(dir, name);
        if (!this.file.exists()) {
            try {
                if (!this.file.createNewFile()) {
                    throw new RuntimeException("Could not create file: " + name);
                }
                if (presetFileName != null) {
                    InputStream inputStream = TBLib.getPlugin().getResource(presetFileName);
                    if (inputStream == null) {
                        throw new RuntimeException("Preset file not found: " + presetFileName);
                    }
                    Path targetPath = this.file.toPath();
                    Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException("Could not load file: " + name + " Exception: " + String.valueOf(e));
        }
        this.options().width(Integer.MAX_VALUE);
        instances.add(this);
    }

    public CConfig(String path, String name) {
        this(path, name, null);
    }

    public static void reloadAll() {
        instances.forEach(CConfig::reload);
    }

    public void reload() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            TBLib.getLogger().info("LcLib Config | Could not load file: " + this.file.getName() + " Exception: " + String.valueOf(e));
        }
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save file: " + this.file.getName() + " Exception: " + String.valueOf(e));
        }
    }

    public void set(@NotNull String path, @Nullable Object value) {
        super.set(path, value);
        this.save();
    }

    public <T> T getOrDefault(String path, T defaultValue) {
        if (!this.contains(path)) {
            return defaultValue;
        }
        Object value = this.get(path);
        if (value == null) {
            return defaultValue;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            Bukkit.getLogger().warning("Type mismatch for path: " + path);
            return defaultValue;
        }
    }

    public <T> T getOrSetDefault(String path, T defaultValue) {
        if (!this.contains(path)) {
            this.set(path, defaultValue);
            return defaultValue;
        }
        Object value = this.get(path);
        if (value == null) {
            this.set(path, defaultValue);
            return defaultValue;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            Bukkit.getLogger().warning("Type mismatch for path: " + path);
            return defaultValue;
        }
    }

    @NotNull
    public ArrayList<ItemStack> getItemStackList(@NotNull String path) {
        List list = this.getList(path);
        if (list == null) {
            return new ArrayList<ItemStack>(0);
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Object obj : list) {
            if (!(obj instanceof ItemStack)) continue;
            result.add(((ItemStack)obj).clone());
        }
        return new ArrayList<ItemStack>(result);
    }

    @NotNull
    public ArrayList<Location> getLocationList(@NotNull String path) {
        List list = this.getList(path);
        if (list == null) {
            return new ArrayList<Location>(0);
        }
        ArrayList<Location> result = new ArrayList<Location>();
        for (Object obj : list) {
            if (!(obj instanceof Location)) continue;
            result.add(((Location)obj).clone());
        }
        return new ArrayList<Location>(result);
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path) {
        ItemStack stack = super.getItemStack(path);
        return stack != null ? stack.clone() : null;
    }

    @Nullable
    public Location getLocation(@NotNull String path) {
        Location location = super.getLocation(path);
        return location != null ? location.clone() : null;
    }
}

