/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.pipelessPipes.Network;

import de.tim2byte.pipelessPipes.GUIs.PipeGUI;
import de.tim2byte.pipelessPipes.Network.PipeNetwork;
import de.tim2byte.pipelessPipes.PipelessPipes;
import de.tim2byte.pipelessPipes.Util.Configs;
import de.tim2byte.pipelessPipes.Util.Messages;
import de.tim2byte.tBLib.Utils.StringUtils;
import de.tim2byte.tBLib.item.ItemBuilder;
import io.papermc.paper.block.TileStateInventoryHolder;
import java.util.ArrayList;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PipeWrenchManager {
    private static final ItemStack PIPE_WRENCH = new ItemBuilder(Configs.CONFIG.getOrSetDefault("wrench_texture", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWUyNjk0YWViYzViYjBiMzQyZTg0M2I1ZDhjOTY3ODEwZjhjM2I2OWM0NjFiMWUwNjFhZjRmNmJlNDE0ZTVjMSJ9fX0=")).setName("<b><gradient:blue:aqua>Pipe Wrench").setID("PipelessPipes:pipe_wrench").shine().build();
    public static final NamespacedKey PIPE_DATA_KEY = new NamespacedKey((Plugin)PipelessPipes.getInstance(), "pipenetwork_node_data");

    public static ItemStack getPipeWrenchUndefined(Player player) {
        return new ItemBuilder(PIPE_WRENCH.clone()).addLore(Messages.WRENCH_DEFAULT_LORE.getMessage(player)).setExtraData("pipe_mode", "none_selected").build();
    }

    public static ItemStack getPipeWrenchWithID(Player player, String netWorkID) {
        return new ItemBuilder(PIPE_WRENCH.clone()).addLore(StringUtils.splitIntoSegments(Messages.WRENCH_SELECTED_LORE.getMessage(player), 26, "<yellow>")).setExtraData("pipe_mode", "selected").setExtraData("pipe_networkID", netWorkID).build();
    }

    public static void clickContainer(Player player, ItemStack itemInUse, TileStateInventoryHolder holder) {
        if (ItemBuilder.getExtraData(itemInUse, "pipe_mode").equals("none_selected")) {
            if (holder.getPersistentDataContainer().has(PIPE_DATA_KEY, PersistentDataType.STRING)) {
                String data = (String)holder.getPersistentDataContainer().getOrDefault(PIPE_DATA_KEY, PersistentDataType.STRING, (Object)"");
                PipeNetwork.PipeNode pipeNode = PipeWrenchManager.dataToNode(player, holder, data);
                if (pipeNode == null) {
                    return;
                }
                PipeNetwork pipeNetwork = PipeNetwork.load(pipeNode.networkID().toString());
                if (pipeNetwork == null) {
                    PipelessPipes.getLog().severe("PipeNetwork | loaded pipe network is null! " + data);
                    player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 244");
                    return;
                }
                player.getInventory().setItemInMainHand(PipeWrenchManager.getPipeWrenchWithID(player, pipeNetwork.getNetworkID().toString()));
                player.openInventory(new PipeGUI(player, pipeNetwork, pipeNode, holder, pipeNode.isInputNode() ? "open_input_node" : "open_output_node").getInventory());
            } else {
                PipeNetwork pipeNetwork = new PipeNetwork(PipeNetwork.getFreeNetID(), player.getUniqueId(), new ArrayList<PipeNetwork.PipeNode>(), new ArrayList<PipeNetwork.PipeNode>());
                PipelessPipes.getLog().info("PipeNetwork | %s created a new PipeNetwork %s".formatted(player.getName(), pipeNetwork.getNetworkID()));
                pipeNetwork.save();
                player.getInventory().setItemInMainHand(PipeWrenchManager.getPipeWrenchWithID(player, pipeNetwork.getNetworkID().toString()));
                player.openInventory(new PipeGUI(player, pipeNetwork, null, holder, "undefined_container").getInventory());
            }
        } else if (ItemBuilder.getExtraData(itemInUse, "pipe_mode").equals("selected")) {
            String networkIDString = ItemBuilder.getExtraData(itemInUse, "pipe_networkID");
            PipeNetwork pipeNetwork = PipeNetwork.load(networkIDString);
            if (pipeNetwork == null) {
                PipelessPipes.getLog().info("PipeNetwork | Resetting Pipe Tool: Network does not exist: " + networkIDString);
                player.getInventory().setItemInMainHand(PipeWrenchManager.getPipeWrenchUndefined(player));
                Messages.WAIT.send(player);
                return;
            }
            if (holder.getPersistentDataContainer().has(PIPE_DATA_KEY, PersistentDataType.STRING)) {
                String data = (String)holder.getPersistentDataContainer().getOrDefault(PIPE_DATA_KEY, PersistentDataType.STRING, (Object)"");
                PipeNetwork.PipeNode pipeNode = PipeWrenchManager.dataToNode(player, holder, data);
                if (pipeNode == null) {
                    return;
                }
                if (!pipeNetwork.getNetworkID().equals(pipeNode.networkID())) {
                    Messages.WRENCH_CONNECTED_TO_ANOTHER_NETWORK.send(player);
                    return;
                }
                player.openInventory(new PipeGUI(player, pipeNetwork, pipeNode, holder, pipeNode.isInputNode() ? "open_input_node" : "open_output_node").getInventory());
            } else {
                player.openInventory(new PipeGUI(player, pipeNetwork, null, holder, "undefined_container").getInventory());
            }
        }
    }

    @Nullable
    private static PipeNetwork.PipeNode dataToNode(Player player, TileStateInventoryHolder holder, String data) {
        if (data.isEmpty()) {
            PipelessPipes.getLog().severe("PipeNetwork | tried to load empty data! " + String.valueOf(holder.getBlock().getLocation()));
            player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 242");
            return null;
        }
        PipeNetwork.PipeNode pipeNode = PipeNetwork.PipeNode.fromString(data);
        if (pipeNode == null) {
            PipelessPipes.getLog().severe("PipeNetwork | loaded pipe node is null! " + data);
            player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 243");
            return null;
        }
        return pipeNode;
    }
}

